# ASN.1 module IMZM-PDU-Descriptions
 OID: _{ itu-t (0) identified-organization (4) etsi (0) itsDomain (5) wg1 (1) ts103724 (103724) imzm (1) version1 (1) }_
 @brief Draft Specification of the Interference Management Zone Message ETSI TS 103 724 Based on the official version available at @url https://forge.etsi.org/rep/ITS/asn1/imzm_ts103724 Modified to import from the draft CDD module Version 3 prepared by Jasja Tijink for ETSI TC ITS WG1 (date 17.05.2022)
## Imports:
 * **[ITS-Container](ITS-Container.md)** *{itu-t (0) identified-organization (4) etsi (0) itsDomain (5) wg1 (1) ts (102894) cdd (2) version3 (3)}*<br/>
   Include ETSI TS 102 894-2 Include references from 
## Data Elements:
### <a name="IMZM"></a>IMZM
DF: Interference Management Zone Message Root This DF includes DEs for the IMZM `protocolVersion`, the IMZ message type identifier `messageID`  and the station identifier `stationID` of the originating ITS-S.

Fields:
* header [**ItsPduHeader**](ITS-Container.md#ItsPduHeader)  (WITH COMPONENTS {... , protocolVersion (1)<br>
   --!
       --! - The DE `protocolVersion` is used to select the appropriate protocol decoder at the receiving
       --!   ITS-S. For TS 103 724 V2.1.1, the value of the DE `protocolVersion` shall be set to 1.
       --! - The DE `messageID` shall be harmonized with other V2X message identifier definitions.
       --!   For IMZM, the DE messageID shall be set to `imzm(15)`.
* imzm [**InterferenceManagementZoneMessage**](#InterferenceManagementZoneMessage) <br>
    messageId(imzm)}),
```asn1
IMZM ::= SEQUENCE {
   header ItsPduHeader (WITH COMPONENTS {... , protocolVersion (1), messageId(imzm)}),
   imzm InterferenceManagementZoneMessage
}
```

### <a name="InterferenceManagementZoneMessage"></a>InterferenceManagementZoneMessage
DF: Interference Management Zone Message This is the actual IMZM Payload. It shall include the time stamp of the IMZM and the applicable containers of type `BasicContainer` and `ImzmContainer`.

Fields:
* generationDeltaTime [**GenerationDeltaTime**](ITS-Container.md#GenerationDeltaTime) <br>
* imzmParameters [**ImzmParameters**](#ImzmParameters) <br>
    
```asn1
InterferenceManagementZoneMessage ::= SEQUENCE {
   generationDeltaTime GenerationDeltaTime, 
   imzmParameters ImzmParameters
}
```

### <a name="ImzmParameters"></a>ImzmParameters
DF: IMZM Parameters The sequence of containers in the IMZM. Other containers may be added in the future.

Fields:
* imzmContainer [**ImzmContainer**](#ImzmContainer) <br>
    
       --!
       --! container specific to the IMZM
```asn1
ImzmParameters ::= SEQUENCE {
    basicContainer BasicContainer, 
    imzmContainer ImzmContainer,
   ...
}
```

### <a name="ImzmContainer"></a>ImzmContainer
DF: IMZM Container The IMZM container includes a sequence of up to 16 interference management zones.  For each interference management zones, it contains a sequence of interference  management zones per channel together with their characteristics.

Fields:
* interferenceManagementZones [**InterferenceManagementZones**](ITS-Container.md#InterferenceManagementZones) <br>
   --!
       --! mapped to the DF_ProtectedCommunicationZone in ETSI TS 102 894-2 
```asn1
ImzmContainer ::= SEQUENCE {
    interferenceManagementZones InterferenceManagementZones,
    ...
}
```



