# Script to extract complete ASN.1 code from ETSI TS 103 666 series of specifications
# Steps to run:
# 1. Download the specification as a word document and open it
# 2. In "view" menu, select draft or web layout (needed to removed page header and footers)
# 3. Save the document as a text file
#      If requested, select "Text encoding: MS-DOS" and "End lines with: CR / LF"
# 4. Call the script: python extract_asn1.py "<text_file>"
# The script generates ETSI_TS_103_666-1_asn1_definitions.asn
import sys

inFile = open(sys.argv[1])
outFile = open("ETSI_TS_103_666-1_asn1_definitions.asn", "w")

copy = False
for line in inFile:
    if line.strip() == "-- ASN1START":
        copy = True
    elif line.strip() == "-- ASN1STOP":
        copy = False
    elif copy:
        outFile.write(line)
inFile.close()
outFile.close()
