/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization.serializers.body;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import org.mockserver.model.JsonBody;
import org.mockserver.serialization.model.JsonBodyDTO;

public class JsonBodyDTOSerializer
extends StdSerializer<JsonBodyDTO> {
    public JsonBodyDTOSerializer() {
        super(JsonBodyDTO.class);
    }

    @Override
    public void serialize(JsonBodyDTO jsonBodyDTO, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartObject();
        if (jsonBodyDTO.getNot() != null && jsonBodyDTO.getNot().booleanValue()) {
            jgen.writeBooleanField("not", jsonBodyDTO.getNot());
        }
        if (jsonBodyDTO.getContentType() != null && !jsonBodyDTO.getContentType().equals(JsonBody.DEFAULT_CONTENT_TYPE.toString())) {
            jgen.writeStringField("contentType", jsonBodyDTO.getContentType());
        }
        jgen.writeStringField("type", jsonBodyDTO.getType().name());
        jgen.writeStringField("json", jsonBodyDTO.getJson());
        if (jsonBodyDTO.getMatchType() != JsonBody.DEFAULT_MATCH_TYPE) {
            jgen.writeStringField("matchType", jsonBodyDTO.getMatchType().name());
        }
        jgen.writeEndObject();
    }
}

