/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Strings;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.BodyMatcher;
import org.mockserver.matchers.MatchType;
import org.mockserver.model.HttpRequest;
import org.skyscreamer.jsonassert.JSONCompare;
import org.skyscreamer.jsonassert.JSONCompareMode;
import org.skyscreamer.jsonassert.JSONCompareResult;

public class JsonStringMatcher
extends BodyMatcher<String> {
    private static final String[] excludedFields = new String[]{"mockServerLogger"};
    private final MockServerLogger mockServerLogger;
    private final String matcher;
    private final MatchType matchType;

    public JsonStringMatcher(MockServerLogger mockServerLogger, String matcher, MatchType matchType) {
        this.mockServerLogger = mockServerLogger;
        this.matcher = matcher;
        this.matchType = matchType;
    }

    @Override
    public boolean matches(HttpRequest context, String matched) {
        boolean result = false;
        try {
            if (Strings.isNullOrEmpty(this.matcher)) {
                result = true;
            } else {
                JSONCompareResult jsonCompareResult;
                JSONCompareMode jsonCompareMode = JSONCompareMode.LENIENT;
                if (this.matchType == MatchType.STRICT) {
                    jsonCompareMode = JSONCompareMode.STRICT;
                }
                if ((jsonCompareResult = JSONCompare.compareJSON(this.matcher, matched, jsonCompareMode)).passed()) {
                    result = true;
                }
                if (!result) {
                    this.mockServerLogger.trace(context, "Failed to perform JSON match \"{}\" with \"{}\" because {}", matched, this.matcher, jsonCompareResult.getMessage());
                }
            }
        }
        catch (Exception e) {
            this.mockServerLogger.trace(context, "Failed to perform JSON match \"{}\" with \"{}\" because {}", matched, this.matcher, e.getMessage());
        }
        return this.not != result;
    }

    @Override
    @JsonIgnore
    protected String[] fieldsExcludedFromEqualsAndHashCode() {
        return excludedFields;
    }
}

