/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.dashboard;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.util.AttributeKey;
import io.netty.util.ReferenceCountUtil;
import java.util.Map;
import org.mockserver.collections.CircularHashMap;
import org.mockserver.exception.ExceptionHandler;
import org.mockserver.filters.MockServerEventLog;
import org.mockserver.log.model.MessageLogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.mock.HttpStateHandler;
import org.mockserver.mock.MockServerMatcher;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.ObjectWithReflectiveEqualsHashCodeToString;
import org.mockserver.serialization.HttpRequestSerializer;
import org.mockserver.serialization.LogEventJsonSerializer;
import org.mockserver.serialization.ObjectMapperFactory;
import org.mockserver.ui.MockServerLogListener;
import org.mockserver.ui.MockServerMatcherListener;
import org.mockserver.ui.model.ValueWithKey;

@ChannelHandler.Sharable
public class DashboardWebSocketServerHandler
extends ChannelInboundHandlerAdapter
implements MockServerLogListener,
MockServerMatcherListener {
    private static final AttributeKey<Boolean> CHANNEL_UPGRADED_FOR_UI_WEB_SOCKET = AttributeKey.valueOf("CHANNEL_UPGRADED_FOR_UI_WEB_SOCKET");
    private static final String UPGRADE_CHANNEL_FOR_UI_WEB_SOCKET_URI = "/_mockserver_ui_websocket";
    private final MockServerLogger mockServerLogger;
    private WebSocketServerHandshaker handshaker;
    private CircularHashMap<ChannelHandlerContext, HttpRequest> clientRegistry = new CircularHashMap(100);
    private HttpRequestSerializer httpRequestSerializer;
    private ObjectMapper objectMapper = ObjectMapperFactory.createObjectMapper();
    private MockServerMatcher mockServerMatcher;
    private MockServerEventLog mockServerLog;
    private Function<ObjectWithReflectiveEqualsHashCodeToString, Object> wrapValueWithKey = new Function<ObjectWithReflectiveEqualsHashCodeToString, Object>(){

        @Override
        public ValueWithKey apply(ObjectWithReflectiveEqualsHashCodeToString input) {
            return new ValueWithKey(input);
        }
    };
    private LogEventJsonSerializer logEventJsonSerializer;

    public DashboardWebSocketServerHandler(HttpStateHandler httpStateHandler) {
        this.mockServerMatcher = httpStateHandler.getMockServerMatcher();
        this.mockServerMatcher.registerListener(this);
        this.mockServerLog = httpStateHandler.getMockServerLog();
        this.mockServerLog.registerListener(this);
        this.mockServerLogger = httpStateHandler.getMockServerLogger();
        this.httpRequestSerializer = new HttpRequestSerializer(this.mockServerLogger);
        this.logEventJsonSerializer = new LogEventJsonSerializer(this.mockServerLogger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        boolean release = true;
        try {
            if (msg instanceof FullHttpRequest && ((FullHttpRequest)msg).uri().equals(UPGRADE_CHANNEL_FOR_UI_WEB_SOCKET_URI)) {
                this.upgradeChannel(ctx, (FullHttpRequest)msg);
                ctx.channel().attr(CHANNEL_UPGRADED_FOR_UI_WEB_SOCKET).set(true);
            } else if (ctx.channel().attr(CHANNEL_UPGRADED_FOR_UI_WEB_SOCKET).get() != null && ctx.channel().attr(CHANNEL_UPGRADED_FOR_UI_WEB_SOCKET).get().booleanValue() && msg instanceof WebSocketFrame) {
                this.handleWebSocketFrame(ctx, (WebSocketFrame)msg);
            } else {
                release = false;
                ctx.fireChannelRead(msg);
            }
        }
        finally {
            if (release) {
                ReferenceCountUtil.release(msg);
            }
        }
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    private void upgradeChannel(final ChannelHandlerContext ctx, FullHttpRequest httpRequest) {
        this.handshaker = new WebSocketServerHandshakerFactory("ws://" + httpRequest.headers().get("Host") + UPGRADE_CHANNEL_FOR_UI_WEB_SOCKET_URI, null, true, Integer.MAX_VALUE).newHandshaker(httpRequest);
        if (this.handshaker == null) {
            WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse(ctx.channel());
        } else {
            this.handshaker.handshake(ctx.channel(), httpRequest, (HttpHeaders)new DefaultHttpHeaders(), ctx.channel().newPromise()).addListener(new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture future) throws Exception {
                    DashboardWebSocketServerHandler.this.clientRegistry.put(ctx, HttpRequest.request());
                }
            });
        }
    }

    private void handleWebSocketFrame(final ChannelHandlerContext ctx, WebSocketFrame frame) throws JsonProcessingException {
        if (frame instanceof CloseWebSocketFrame) {
            this.handshaker.close(ctx.channel(), (CloseWebSocketFrame)frame.retain()).addListener(new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture future) {
                    DashboardWebSocketServerHandler.this.clientRegistry.remove(ctx);
                }
            });
        } else if (frame instanceof TextWebSocketFrame) {
            try {
                HttpRequest httpRequest = this.httpRequestSerializer.deserialize(((TextWebSocketFrame)frame).text());
                this.clientRegistry.put(ctx, httpRequest);
                this.sendUpdate(httpRequest, ctx);
            }
            catch (IllegalArgumentException iae) {
                this.sendMessage(ctx, ImmutableMap.of("error", iae.getMessage()));
            }
        } else if (frame instanceof PingWebSocketFrame) {
            ctx.write(new PongWebSocketFrame(frame.content().retain()));
        } else {
            throw new UnsupportedOperationException(String.format("%s frame types not supported", frame.getClass().getName()));
        }
    }

    private void sendMessage(ChannelHandlerContext ctx, ImmutableMap<String, Object> message) throws JsonProcessingException {
        ctx.channel().writeAndFlush(new TextWebSocketFrame(this.objectMapper.writeValueAsString(message)));
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (ExceptionHandler.shouldNotIgnoreException(cause)) {
            this.mockServerLogger.error("web socket server caught exception", cause);
        }
        ctx.close();
    }

    @Override
    public void updated(MockServerEventLog mockServerLog) {
        for (Map.Entry registryEntry : this.clientRegistry.entrySet()) {
            this.sendUpdate((HttpRequest)registryEntry.getValue(), (ChannelHandlerContext)registryEntry.getKey());
        }
    }

    @Override
    public void updated(MockServerMatcher mockServerMatcher) {
        for (Map.Entry registryEntry : this.clientRegistry.entrySet()) {
            this.sendUpdate((HttpRequest)registryEntry.getValue(), (ChannelHandlerContext)registryEntry.getKey());
        }
    }

    private void sendUpdate(HttpRequest httpRequest, ChannelHandlerContext channelHandlerContext) {
        try {
            this.sendMessage(channelHandlerContext, ImmutableMap.of("activeExpectations", Lists.transform(this.mockServerMatcher.retrieveExpectations(httpRequest), this.wrapValueWithKey), "recordedExpectations", Lists.transform(this.mockServerLog.retrieveExpectations(httpRequest), this.wrapValueWithKey), "recordedRequests", Lists.transform(this.mockServerLog.retrieveRequestLogEntries(httpRequest), this.wrapValueWithKey), "logMessages", Lists.transform(this.mockServerLog.retrieveMessageLogEntries(httpRequest), new Function<MessageLogEntry, Object>(){

                @Override
                public ValueWithKey apply(MessageLogEntry input) {
                    return new ValueWithKey(DashboardWebSocketServerHandler.this.logEventJsonSerializer.serialize(input), input.key());
                }
            })));
        }
        catch (JsonProcessingException jpe) {
            this.mockServerLogger.error("Exception while updating UI", jpe);
        }
    }
}

