/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import org.mockserver.matchers.BodyMatcher;
import org.mockserver.validator.xmlschema.XmlSchemaValidator;

public class XmlSchemaMatcher
extends BodyMatcher<String> {
    private String schema;
    private XmlSchemaValidator xmlSchemaValidator;

    public XmlSchemaMatcher(String schema) {
        this.schema = schema;
        this.xmlSchemaValidator = new XmlSchemaValidator(schema);
    }

    @Override
    protected String[] fieldsExcludedFromEqualsAndHashCode() {
        return new String[]{"logger", "xmlSchemaValidator"};
    }

    @Override
    public boolean matches(String matched) {
        boolean result = false;
        try {
            String validation = this.xmlSchemaValidator.isValid(matched);
            result = validation.isEmpty();
            if (!result) {
                this.logger.trace("Failed to perform XML match \"{}\" with schema \"{}\" because {}", matched, this.schema, validation);
            }
        }
        catch (Exception e) {
            this.logger.trace("Failed to perform XML match \"{}\" with schema \"{}\" because {}", matched, this.schema, e.getMessage());
        }
        return this.reverseResultIfNot(result);
    }
}

