/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import io.netty.handler.codec.http.QueryStringDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mockserver.collections.CaseInsensitiveRegexMultiMap;
import org.mockserver.matchers.BodyMatcher;
import org.mockserver.matchers.MultiValueMapMatcher;
import org.mockserver.model.KeyToMultiValue;
import org.mockserver.model.Parameter;
import org.mockserver.model.Parameters;

public class ParameterStringMatcher
extends BodyMatcher<String> {
    private final MultiValueMapMatcher matcher;

    public ParameterStringMatcher(Parameters parameters) {
        this.matcher = new MultiValueMapMatcher(parameters != null ? parameters.toCaseInsensitiveRegexMultiMap() : new CaseInsensitiveRegexMultiMap());
    }

    @Override
    public boolean matches(String matched) {
        boolean result = false;
        if (this.matcher.matches(this.parseString(matched))) {
            result = true;
        }
        if (!result) {
            this.logger.trace("Failed to match [{}] with [{}]", (Object)matched, (Object)this.matcher);
        }
        return this.reverseResultIfNot(result);
    }

    private List<KeyToMultiValue> parseString(String matched) {
        HashMap<String, Parameter> mappedParameters = new HashMap<String, Parameter>();
        Map<String, List<String>> parameters = new QueryStringDecoder("?" + matched).parameters();
        for (String name : parameters.keySet()) {
            for (String value : parameters.get(name)) {
                if (mappedParameters.containsKey(name)) {
                    ((Parameter)mappedParameters.get(name)).addValue(value);
                    continue;
                }
                mappedParameters.put(name, new Parameter(name, value));
            }
        }
        return new ArrayList<KeyToMultiValue>(mappedParameters.values());
    }
}

