/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.logging;

import java.util.List;
import org.mockserver.formatting.StringFormatter;
import org.mockserver.log.model.MessageLogEntry;
import org.mockserver.mock.HttpStateHandler;
import org.mockserver.model.HttpRequest;
import org.slf4j.Logger;

public class LoggingFormatter {
    private final Logger logger;
    private final HttpStateHandler httpStateHandler;

    public LoggingFormatter(Logger logger, HttpStateHandler httpStateHandler) {
        this.logger = logger;
        this.httpStateHandler = httpStateHandler;
    }

    public void traceLog(String message, Object ... arguments) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(StringFormatter.formatLogMessage(message, arguments));
        }
    }

    public void infoLog(HttpRequest request, String message, Object ... arguments) {
        String logMessage = StringFormatter.formatLogMessage(message, arguments);
        this.logger.info(logMessage);
        this.addLogEvents(request, logMessage);
    }

    public void infoLog(List<HttpRequest> requests, String message, Object ... arguments) {
        String logMessage = StringFormatter.formatLogMessage(message, arguments);
        this.logger.info(logMessage);
        this.addLogEvents(requests, logMessage);
    }

    public void errorLog(HttpRequest request, String message, Object ... arguments) {
        String logMessage = StringFormatter.formatLogMessage(message, arguments);
        this.logger.error(logMessage);
        this.addLogEvents(request, logMessage);
    }

    public void errorLog(HttpRequest request, Throwable throwable, String message, Object ... arguments) {
        String logMessage = StringFormatter.formatLogMessage(message, arguments);
        this.logger.error(logMessage, throwable);
        this.addLogEvents(request, logMessage);
    }

    public void errorLog(List<HttpRequest> requests, Throwable throwable, String message, Object ... arguments) {
        String logMessage = StringFormatter.formatLogMessage(message, arguments);
        this.logger.error(logMessage, throwable);
        this.addLogEvents(requests, logMessage);
    }

    private void addLogEvents(HttpRequest request, String logMessage) {
        if (this.httpStateHandler != null) {
            this.httpStateHandler.log(new MessageLogEntry(request, logMessage));
        }
    }

    private void addLogEvents(List<HttpRequest> requests, String logMessage) {
        if (this.httpStateHandler != null) {
            for (HttpRequest httpRequest : requests) {
                this.httpStateHandler.log(new MessageLogEntry(httpRequest, logMessage));
            }
        }
    }
}

