/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.netty;

import com.google.common.util.concurrent.SettableFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.ssl.NotSslRecordException;
import javax.net.ssl.SSLException;
import org.mockserver.model.HttpResponse;

public class HttpClientHandler
extends SimpleChannelInboundHandler<HttpResponse> {
    private final SettableFuture<HttpResponse> responseFuture = SettableFuture.create();

    public HttpClientHandler() {
        super(false);
    }

    public SettableFuture<HttpResponse> getResponseFuture() {
        return this.responseFuture;
    }

    @Override
    public void channelRead0(ChannelHandlerContext ctx, HttpResponse response) {
        this.responseFuture.set(response);
        ctx.close();
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (this.isNotSslException(cause)) {
            cause.printStackTrace();
        }
        this.responseFuture.setException(cause);
        ctx.close();
    }

    private boolean isNotSslException(Throwable cause) {
        return !(cause.getCause() instanceof SSLException) && !(cause instanceof DecoderException | cause instanceof NotSslRecordException);
    }
}

