/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.serialization.model;

import com.google.common.net.MediaType;
import org.mockserver.client.serialization.model.BodyWithContentTypeDTO;
import org.mockserver.model.StringBody;

public class StringBodyDTO
extends BodyWithContentTypeDTO {
    private String string;
    private boolean subString;

    public StringBodyDTO(StringBody stringBody) {
        this(stringBody, stringBody.getNot());
    }

    public StringBodyDTO(StringBody stringBody, Boolean not) {
        super(stringBody.getType(), not, stringBody.getContentType());
        this.string = stringBody.getValue();
        this.subString = stringBody.isSubString();
    }

    protected StringBodyDTO() {
    }

    public String getString() {
        return this.string;
    }

    public boolean isSubString() {
        return this.subString;
    }

    @Override
    public StringBody buildObject() {
        return new StringBody(this.string, this.subString, this.contentType != null ? MediaType.parse(this.contentType) : null);
    }
}

