/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.proxy.relay;

import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.HttpMessage;
import org.mockserver.exception.ExceptionHandler;
import org.slf4j.Logger;

public class ProxyRelayHandler<T extends HttpMessage>
extends SimpleChannelInboundHandler<T> {
    private final Logger logger;
    private volatile Channel channel;

    public ProxyRelayHandler(Channel channel, Logger logger) {
        super(false);
        this.channel = channel;
        this.logger = logger;
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) {
        ctx.read();
        ctx.write(Unpooled.EMPTY_BUFFER);
    }

    @Override
    public void channelRead0(final ChannelHandlerContext ctx, T msg) {
        this.channel.writeAndFlush(msg).addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) {
                if (future.isSuccess()) {
                    ctx.channel().read();
                } else {
                    ProxyRelayHandler.this.logger.error("Exception while returning writing", future.cause());
                    future.channel().close();
                }
            }
        });
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) {
        ExceptionHandler.closeOnFlush(this.channel);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (!ExceptionHandler.shouldIgnoreException(cause)) {
            this.logger.warn("Exception caught by proxy relay handler -> closing pipeline " + ctx.channel(), cause);
        }
        ExceptionHandler.closeOnFlush(ctx.channel());
    }
}

