/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mockserver;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelOption;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.AttributeKey;
import java.util.Arrays;
import org.mockserver.lifecycle.LifeCycle;
import org.mockserver.mock.HttpStateHandler;
import org.mockserver.mockserver.MockServerInitializer;

public class MockServer
extends LifeCycle<MockServer> {
    public static final AttributeKey<MockServer> MOCK_SERVER = AttributeKey.valueOf("MOCK_SERVER");

    public MockServer(Integer ... requestedPortBindings) {
        if (requestedPortBindings == null || requestedPortBindings.length == 0) {
            throw new IllegalArgumentException("You must specify at least one port");
        }
        this.serverBootstrap = ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(this.bossGroup, this.workerGroup).option(ChannelOption.SO_BACKLOG, 1024)).channel(NioServerSocketChannel.class)).childOption(ChannelOption.AUTO_READ, true).childOption(ChannelOption.ALLOCATOR, PooledByteBufAllocator.DEFAULT).option(ChannelOption.WRITE_BUFFER_WATER_MARK, new WriteBufferWaterMark(8192, 32768))).childHandler(new MockServerInitializer()).childAttr(MOCK_SERVER, this).childAttr(HttpStateHandler.STATE_HANDLER, new HttpStateHandler());
        this.bindToPorts(Arrays.asList(requestedPortBindings));
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                MockServer.this.bossGroup.shutdownGracefully();
                MockServer.this.workerGroup.shutdownGracefully();
                try {
                    MockServer.this.bossGroup.terminationFuture().sync();
                    MockServer.this.workerGroup.terminationFuture().sync();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }));
    }
}

