/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import com.google.common.base.Strings;
import org.mockserver.matchers.BodyMatcher;
import org.mockserver.model.NottableString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExactStringMatcher
extends BodyMatcher<NottableString> {
    private static Logger logger = LoggerFactory.getLogger(ExactStringMatcher.class);
    private final NottableString matcher;

    public ExactStringMatcher(String matcher) {
        this.matcher = NottableString.string(matcher);
    }

    public ExactStringMatcher(NottableString matcher) {
        this.matcher = matcher;
    }

    public static boolean matches(String matcher, String matched, boolean ignoreCase) {
        boolean result = false;
        if (Strings.isNullOrEmpty(matcher)) {
            result = true;
        } else if (matched != null) {
            if (matched.equals(matcher)) {
                result = true;
            }
            if (ignoreCase && matched.equalsIgnoreCase(matcher)) {
                result = true;
            }
        }
        return result;
    }

    @Override
    public boolean matches(String matched) {
        return this.matches(NottableString.string(matched));
    }

    @Override
    public boolean matches(NottableString matched) {
        boolean result = false;
        if (ExactStringMatcher.matches(this.matcher.getValue(), matched.getValue(), false)) {
            result = true;
        }
        if (!result) {
            logger.trace("Failed to match [{}] with [{}]", (Object)matched, (Object)this.matcher);
        }
        return this.matcher.isNot() != this.reverseResultIfNot(result);
    }

    @Override
    public String[] fieldsExcludedFromEqualsAndHashCode() {
        return new String[]{"logger"};
    }
}

