/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.serialization.java;

import com.google.common.base.Strings;
import org.mockserver.character.Character;
import org.mockserver.client.serialization.Base64Converter;
import org.mockserver.client.serialization.java.DelayToJavaSerializer;
import org.mockserver.client.serialization.java.ToJavaSerializer;
import org.mockserver.model.HttpError;

public class HttpErrorToJavaSerializer
implements ToJavaSerializer<HttpError> {
    private final Base64Converter base64Converter = new Base64Converter();

    @Override
    public String serialize(int numberOfSpacesToIndent, HttpError httpError) {
        StringBuffer output = new StringBuffer();
        if (httpError != null) {
            this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append("error()");
            if (httpError.getDelay() != null) {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(".withDelay(").append(new DelayToJavaSerializer().serialize(0, httpError.getDelay())).append(")");
            }
            if (httpError.getDropConnection() != null) {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(".withDropConnection(").append(httpError.getDropConnection()).append(")");
            }
            if (httpError.getResponseBytes() != null) {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(".withResponseBytes(new Base64Converter().base64StringToBytes(\"").append(this.base64Converter.bytesToBase64String(httpError.getResponseBytes())).append("\"))");
            }
        }
        return output.toString();
    }

    private StringBuffer appendNewLineAndIndent(int numberOfSpacesToIndent, StringBuffer output) {
        return output.append(Character.NEW_LINE).append(Strings.padStart("", numberOfSpacesToIndent, ' '));
    }
}

