/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mock.action;

import java.util.Arrays;
import org.mockserver.client.netty.NettyHttpClient;
import org.mockserver.client.serialization.model.HttpRequestDTO;
import org.mockserver.filters.HopByHopHeaderFilter;
import org.mockserver.logging.LoggingFormatter;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.HttpTemplate;
import org.mockserver.templates.engine.TemplateEngine;
import org.mockserver.templates.engine.javascript.JavaScriptTemplateEngine;
import org.mockserver.templates.engine.velocity.VelocityTemplateEngine;

public class HttpForwardTemplateActionHandler {
    private final LoggingFormatter logFormatter;
    private JavaScriptTemplateEngine javaScriptTemplateEngine;
    private VelocityTemplateEngine velocityTemplateEngine;
    private NettyHttpClient httpClient = new NettyHttpClient();
    private HopByHopHeaderFilter hopByHopHeaderFilter = new HopByHopHeaderFilter();

    public HttpForwardTemplateActionHandler(LoggingFormatter logFormatter) {
        this.logFormatter = logFormatter;
        this.javaScriptTemplateEngine = new JavaScriptTemplateEngine(logFormatter);
        this.velocityTemplateEngine = new VelocityTemplateEngine(logFormatter);
    }

    public HttpResponse handle(HttpTemplate httpTemplate, HttpRequest originalRequest) {
        HttpRequest templatedRequest;
        HttpResponse httpResponse = HttpResponse.notFoundResponse();
        TemplateEngine templateEngine = null;
        switch (httpTemplate.getTemplateType()) {
            case VELOCITY: {
                templateEngine = this.velocityTemplateEngine;
                break;
            }
            case JAVASCRIPT: {
                templateEngine = this.javaScriptTemplateEngine;
                break;
            }
            default: {
                throw new RuntimeException("Unknown no template engine available for " + (Object)((Object)httpTemplate.getTemplateType()));
            }
        }
        if (templateEngine != null && (templatedRequest = (HttpRequest)templateEngine.executeTemplate(httpTemplate.getTemplate(), originalRequest, HttpRequestDTO.class)) != null) {
            httpResponse = this.sendRequest(originalRequest, templatedRequest);
        }
        httpTemplate.applyDelay();
        return httpResponse;
    }

    private HttpResponse sendRequest(HttpRequest originalRequest, HttpRequest templatedRequest) {
        if ((templatedRequest = this.hopByHopHeaderFilter.onRequest(templatedRequest)) != null) {
            try {
                return this.httpClient.sendRequest(templatedRequest);
            }
            catch (Exception e) {
                this.logFormatter.errorLog(Arrays.asList(originalRequest, templatedRequest), (Throwable)e, "Exception forwarding request " + templatedRequest, new Object[0]);
            }
        }
        return null;
    }
}

