/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.serialization.serializers.collections;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import org.mockserver.model.KeyToMultiValue;
import org.mockserver.model.KeysToMultiValues;
import org.mockserver.model.NottableString;

public abstract class KeysToMultiValuesSerializer<T extends KeysToMultiValues<? extends KeyToMultiValue, T>>
extends StdSerializer<T> {
    KeysToMultiValuesSerializer(Class<T> valueClass) {
        super(valueClass);
    }

    @Override
    public void serialize(T collection, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartObject();
        for (KeyToMultiValue keyToMultiValue : ((KeysToMultiValues)collection).getEntries()) {
            jgen.writeFieldName(NottableString.serialiseNottableString(keyToMultiValue.getName()));
            jgen.writeStartArray(keyToMultiValue.getValues().size());
            for (NottableString nottableString : keyToMultiValue.getValues()) {
                jgen.writeString(NottableString.serialiseNottableString(nottableString));
            }
            jgen.writeEndArray();
        }
        jgen.writeEndObject();
    }
}

