/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.serialization.model;

import com.google.common.net.MediaType;
import org.mockserver.client.serialization.model.BodyWithContentTypeDTO;
import org.mockserver.matchers.MatchType;
import org.mockserver.model.Body;
import org.mockserver.model.JsonBody;

public class JsonBodyDTO
extends BodyWithContentTypeDTO {
    private String json;
    private MatchType matchType;

    public JsonBodyDTO(JsonBody jsonBody) {
        this(jsonBody, (Boolean)false);
    }

    public JsonBodyDTO(JsonBody jsonBody, Boolean not) {
        super(Body.Type.JSON, not, jsonBody.getContentType());
        this.json = jsonBody.getValue();
        this.matchType = jsonBody.getMatchType();
    }

    protected JsonBodyDTO() {
    }

    public String getJson() {
        return this.json;
    }

    public MatchType getMatchType() {
        return this.matchType;
    }

    @Override
    public JsonBody buildObject() {
        return new JsonBody(this.getJson(), this.contentType != null ? MediaType.parse(this.contentType) : null, this.matchType);
    }
}

