/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.templates.engine.velocity;

import java.io.StringWriter;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.apache.velocity.script.VelocityScriptEngineFactory;
import org.mockserver.character.Character;
import org.mockserver.client.serialization.model.DTO;
import org.mockserver.formatting.StringFormatter;
import org.mockserver.logging.LoggingFormatter;
import org.mockserver.model.HttpRequest;
import org.mockserver.templates.engine.TemplateEngine;
import org.mockserver.templates.engine.model.HttpRequestTemplateObject;
import org.mockserver.templates.engine.serializer.HttpTemplateOutputDeserializer;

public class VelocityTemplateEngine
implements TemplateEngine {
    private static final ScriptEngineManager manager = new ScriptEngineManager();
    private static final ScriptEngine engine;
    private final LoggingFormatter logFormatter;
    private HttpTemplateOutputDeserializer httpTemplateOutputDeserializer;

    public VelocityTemplateEngine(LoggingFormatter logFormatter) {
        this.logFormatter = logFormatter;
        this.httpTemplateOutputDeserializer = new HttpTemplateOutputDeserializer(logFormatter);
    }

    @Override
    public <T> T executeTemplate(String template, HttpRequest request, Class<? extends DTO<T>> dtoClass) {
        T result = null;
        try {
            StringWriter writer = new StringWriter();
            ScriptContext context = engine.getContext();
            context.setWriter(writer);
            context.setAttribute("request", new HttpRequestTemplateObject(request), 100);
            engine.eval(template);
            this.logFormatter.infoLog(request, "Generated output:{}" + Character.NEW_LINE + " from template:{}" + Character.NEW_LINE + " for request:{}", ((Object)writer).toString(), template, request);
            result = this.httpTemplateOutputDeserializer.deserializer(request, ((Object)writer).toString(), dtoClass);
        }
        catch (Exception e) {
            throw new RuntimeException(StringFormatter.formatLogMessage("Exception transforming template:{}" + Character.NEW_LINE + " for request:{}", template, request), e);
        }
        return result;
    }

    static {
        manager.registerEngineName("velocity", new VelocityScriptEngineFactory());
        engine = manager.getEngineByName("velocity");
    }
}

