*** Settings ***
Library    String
Resource    environment/variables.txt   
Library    REST    ${NFVO_SCHEMA}://${NFVO_HOST}:${NFVO_PORT}     ssl_verify=false
Library    OperatingSystem
Library    JSONLibrary
Library    JSONSchemaLibrary    schemas/

Suite Setup    Check resource existence and get CallbackUri

*** Test Cases ***
Ns Lcm Operation Occurrence Notification
    [Documentation]    Test ID: 5.3.2.26.1
    ...    Test title: Ns Lcm Operation Occurrence Notification
    ...    Test objective: The objective is to test that Ns Lcm Operation Occurrence Notification is delivered with success to the notification consumer.
    ...    Pre-conditions: A subscription for NS LCM Operation Occurrence notifications is available in the NFVO.
    ...    Reference: Clause 6.4.18.3.1 - ETSI GS NFV-SOL 005 [3] v2.7.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none 
    Post Ns Lcm Operation Occurrence Notification
    Check HTTP Response Status Code Is    204
    
Ns Identifier Creation Notification
    [Documentation]    Test ID: 5.3.2.26.2
    ...    Test title: Ns Identifier Creation Notification
    ...    Test objective: The objective is to test that Ns Identifier Creation Notification is delivered with success to the notification consumer.
    ...    Pre-conditions: A subscription for Ns Identifier Creation notification is available in the NFVO.
    ...    Reference: Clause 6.4.18.3.1 - ETSI GS NFV-SOL 005 [3] v2.7.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none 
    Post Ns Identifier Creation Notification
    Check HTTP Response Status Code Is    204
    
Ns Identifier Deletion Notification
    [Documentation]    Test ID: 5.3.2.26.3
    ...    Test title: Ns Identifier Deletion Notification
    ...    Test objective: The objective is to test that Ns Identifier Deletion Notification is delivered with success to the notification consumer.
    ...    Pre-conditions: A subscription for Ns Identifier Deletion notification is available in the NFVO.
    ...    Reference: Clause 6.4.18.3.1 - ETSI GS NFV-SOL 005 [3] v2.7.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none 
    Post Ns Identifier Deletion Notification
    Check HTTP Response Status Code Is    204
    
*** Keywords ***
Check resource existence and get CallbackUri
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions/${subscriptionId}
    Integer    response status    200
    Validate Json    response body    subscription.schema.json
    Set Global Variable    ${callbackResp}    response body callbackUri

Check HTTP Response Status Code Is
    [Arguments]    ${expected_status}    
    Should Be Equal As Strings    ${response['status']}    ${expected_status}
    Log    Status code validated 
    
Post Ns Lcm Operation Occurrence Notification
    log    Trying to perform a POST to get notification
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    ${template} =    Get File    jsons/NsLcmOperationOccurrenceNotification.json
    ${body}=        Format String   ${template}    nsInstanceId=${nsInstanceId}    nsLcmOpOccId=${nsLcmOpOccId}    subscriptionId=${subscriptionId}   
    Post    ${callbackResp}    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
Post Ns Identifier Creation Notification
    log    Trying to perform a POST to get notification
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    ${template} =    Get File    jsons/NsIdentifierCreationNotification.json
    ${body}=        Format String   ${template}    subscriptionId=${subscriptionId}    nsInstanceId=${nsInstanceId}   
    Post    ${callbackResp}    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
Post Ns Identifier Deletion Notification
    log    Trying to perform a POST to get notification
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    ${template} =    Get File    jsons/NsIdentifierDeletionNotification.json
    ${body}=        Format String   ${template}    subscriptionId=${subscriptionId}    nsInstanceId=${nsInstanceId}   
    Post    ${callbackResp}    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
