*** Settings ***
Library    String
Library    OperatingSystem
Resource    environment/variables.txt  
Library    JSONLibrary
Library    JSONSchemaLibrary    schemas/
Library    REST     ${NFVO_SCHEMA}://${NFVO_HOST}:${NFVO_PORT}       ssl_verify=false
Suite Setup    Check resource existence and get CallbackUri

*** Test Cases ***
NS Fault Alarm Notification
    [Documentation]    Test ID: 5.3.3.7.1
    ...    Test title: NS Fault Alarm Notification
    ...    Test objective: The objective is to test that NS Fault Alarm Notification is delivered with success to the notification consumer
    ...    Pre-conditions: A NS instance is instantiated, and a subscription for fault alarm notifications is available in the NFVO.
    ...    Reference: Clause 8.4.6.3.1 - ETSI GS NFV-SOL 005 [3] v2.7.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none 
    Post Alarm Notification
    Check HTTP Response Status Code Is    204
    
NS Fault Alarm Cleared Notification
    [Documentation]    Test ID: 5.3.3.7.2
    ...    Test title: NS Fault Alarm Cleared Notification
    ...    Test objective: The objective is to test that NS Fault Alarm Cleared Notification is delivered with success to the notification consumer
    ...    Pre-conditions: A NS instance is instantiated, and a subscription for fault alarm cleared notifications is available in the NFVO.
    ...    Reference: Clause 8.4.6.3.1 - ETSI GS NFV-SOL 005 [3] v2.7.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none 
    Post Alarm Cleared Notification
    Check HTTP Response Status Code Is    204
    
NS Fault Alarm List Rebuilt Notification
    [Documentation]    Test ID: 5.3.3.7.3
    ...    Test title: NS Fault Alarm List Rebuilt Notification
    ...    Test objective: The objective is to test that NS Fault Alarm List Rebuilt Notification is delivered with success to the notification consumer
    ...    Pre-conditions: A NS instance is instantiated, and a subscription for fault alarm list rebuilt notifications is available in the NFVO.
    ...    Reference: Clause 8.4.6.3.1 - ETSI GS NFV-SOL 005 [3] v2.7.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none 
    Post Alarm List Rebuilt Notification
    Check HTTP Response Status Code Is    204
    
*** Keywords ***
Check resource existence and get CallbackUri
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions/${subscriptionId}
    Integer    response status    200
    Validate Json    response body    FmSubscription.schema.json
    Set Global Variable    ${callbackResp}    response body callbackUri

Check HTTP Response Status Code Is
    [Arguments]    ${expected_status}    
    Should Be Equal As Strings    ${response['status']}    ${expected_status}
    Log    Status code validated 
    
Post Alarm Notification
    log    Trying to perform a POST to get notification
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    ${template} =    Get File    jsons/AlarmNotification.json
    ${body}=        Format String   ${template}    subscriptionId=${subscriptionId}   
    Post    ${callbackResp}    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}

Post Alarm Cleared Notification
    log    Trying to perform a POST to get notification
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    ${template} =    Get File    jsons/AlarmClearedNotification.json
    ${body}=        Format String   ${template}    subscriptionId=${subscriptionId}    alarmId=${alarmId}
    Post    ${callbackResp}    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
Post Alarm List Rebuilt Notification
    log    Trying to perform a POST to get notification
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    ${template} =    Get File    jsons/AlarmListRebuiltNotification.json
    ${body}=        Format String   ${template}    subscriptionId=${subscriptionId}   
    Post    ${callbackResp}    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}