*** Settings ***
# Suite setup     Expect spec    SOL002-VNFLifecycleManagement-API.yaml
Resource    environment/variables.txt 
Resource    VnfLcmOperationKeywords.robot
Library    REST    ${VNFM_SCHEMA}://${VNFM_HOST}:${VNFM_PORT}      ssl_verify=false  
Library    OperatingSystem
Library    DependencyLibrary
Library    JSONLibrary
Library    JSONSchemaLibrary    schemas/


*** Variables ***
${original_etag}    1234

*** Test Cases ***
POST Individual VNFInstance - Method not implemented
    [Documentation]    Test ID: 6.3.5.2.1
    ...    Test title: POST Individual VNFInstance - Method not implemented
    ...    Test objective: The objective is to test that POST method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.3.3.1 - ETSI GS NFV-SOL 002 [2] v2.7.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none
    ...    Post-Conditions: none
    POST individual vnfInstance
    Check HTTP Response Status Code Is    405
    
GET Information about an individual VNF Instance
    [Documentation]    Test ID: 6.3.5.2.2
    ...    Test title: GET Information about an individual VNF Instance
    ...    Test objective: The objective is to create a new VNF instance resource
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.3.3.2 - ETSI GS NFV-SOL 002 [2] v2.7.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none
    ...    Post-Conditions: none
    GET individual vnfInstance
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    vnfInstance
    Check HTTP Response Body vnfInstance content against VNF Descriptor
    
PUT Individual VNFInstance - Method not implemented 
     [Documentation]    Test ID: 6.3.5.2.3
    ...    Test title: PUT Individual VNFInstance - Method not implemented
    ...    Test objective: The objective is to test that PUT method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.3.3.3 - ETSI GS NFV-SOL 002 [2] v2.7.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none
    ...    Post-Conditions: VNF instance not modified
    PUT individual vnfInstance
    Check HTTP Response Status Code Is    405

PATCH Individual VNFInstance
    [Documentation]    Test ID: 6.3.5.2.4
    ...    Test title: PATCH Individual VNFInstance
    ...    Test objective: This method modifies an individual VNF instance resource
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.3.3.4 - ETSI GS NFV-SOL 002 [2] v2.7.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none
    ...    Post-Conditions: VNF instance modified
    PATCH individual vnfInstance
    Check HTTP Response Status Code Is    202
    Check Operation Occurrence Id

PATCH Individual VNFInstance Precondition failed
    [Documentation]    Test ID: 6.3.5.2.5
    ...    Test title: PATCH Individual VNFInstance Precondition failed
    ...    Test objective: The objective is to that the modification of individual VNFInstance fails because precondition given in an HTTP request header is not fulfilled. Typically, this is due to an ETag mismatch, indicating that the resource was modified by another entity.
    ...    Pre-conditions:  none
    ...    Reference: Clause 5.4.3.3.4 - ETSI GS NFV-SOL 002 [2] v2.7.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none
    ...    Post-Conditions: none
    PATCH individual vnfInstance
    Check HTTP Response Status Code Is    412
    Check HTTP Response Body Json Schema Is    ProblemDetails

PATCH Individual VNFInstance Conflict
    [Documentation]    Test ID: 6.3.5.2.6
    ...    Test title: PATCH Individual VNFInstance Conflict
    ...    Test objective: The objective is to verify that modification operation cannot be executed currently, due to a conflict with the state of the VNF instance resource because another LCM Operation is ongoing. 
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.3.3.4 - ETSI GS NFV-SOL 002 [2] v2.7.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none
    ...    Post-Conditions: none
     PATCH individual vnfInstance
    Check HTTP Response Status Code Is    409
    Check HTTP Response Body Json Schema Is    ProblemDetails

DELETE Individual VNFInstance
    [Documentation]    Test ID: 6.3.5.2.7
    ...    Test title: DELETE Individual VNFInstance
    ...    Test objective: The objective is to delete a VNF instance
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.3.3.5 - ETSI GS NFV-SOL 002 [2] v2.7.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none
    ...    Post-Conditions: VNF instance deleted
    DELETE individual vnfInstance
    Check HTTP Response Status Code Is    204

DELETE Individual VNFInstance Conflict
     [Documentation]    Test ID: 6.3.5.2.8
    ...    Test title: DELETE Individual VNFInstance Conflict
    ...    Test objective: The objective is to verify that The operation cannot be executed currently, due to a conflict with the state of the VNF instance resource.
    ...    Pre-conditions: VNF instance resource is in INSTANTIATED state
    ...    Reference: Clause 5.4.3.3.5 - ETSI GS NFV-SOL 002 [2] v2.7.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none
    ...    Post-Conditions: none
    DELETE individual vnfInstance
    Check HTTP Response Status Code Is    409
    Check HTTP Response Body Json Schema Is    ProblemDetails