/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.proxy.http;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelOption;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.net.InetSocketAddress;
import java.util.Arrays;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.mock.HttpStateHandler;
import org.mockserver.proxy.Proxy;
import org.mockserver.proxy.http.HttpProxyUnificationHandler;

public class HttpProxy
extends Proxy<HttpProxy> {
    public HttpProxy(Integer ... requestedPortBindings) {
        if (requestedPortBindings == null || requestedPortBindings.length == 0) {
            throw new IllegalArgumentException("You must specify at least one port");
        }
        this.serverBootstrap = ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(this.bossGroup, this.workerGroup).option(ChannelOption.SO_BACKLOG, 1024)).channel(NioServerSocketChannel.class)).childOption(ChannelOption.AUTO_READ, true).childOption(ChannelOption.ALLOCATOR, PooledByteBufAllocator.DEFAULT).option(ChannelOption.WRITE_BUFFER_WATER_MARK, new WriteBufferWaterMark(8192, 32768))).childHandler(new HttpProxyUnificationHandler()).childAttr(HTTP_PROXY, this).childAttr(HTTP_CONNECT_SOCKET, new InetSocketAddress(requestedPortBindings[0])).childAttr(HttpStateHandler.STATE_HANDLER, new HttpStateHandler());
        this.bindToPorts(Arrays.asList(requestedPortBindings));
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                HttpProxy.this.bossGroup.shutdownGracefully();
                HttpProxy.this.workerGroup.shutdownGracefully();
                try {
                    HttpProxy.this.bossGroup.terminationFuture().sync();
                    HttpProxy.this.workerGroup.terminationFuture().sync();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }));
    }

    @Override
    protected void started(Integer port) {
        super.started(port);
        ConfigurationProperties.proxyPort(port);
        System.setProperty("http.proxyHost", "127.0.0.1");
        System.setProperty("http.proxyPort", port.toString());
    }

    @Override
    protected void stopped() {
        System.clearProperty("http.proxyHost");
        System.clearProperty("http.proxyPort");
    }
}

