/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import org.apache.commons.lang3.StringUtils;
import org.mockserver.matchers.BodyMatcher;
import org.mockserver.model.NottableString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubStringMatcher
extends BodyMatcher<NottableString> {
    private static Logger logger = LoggerFactory.getLogger(SubStringMatcher.class);
    private final NottableString matcher;

    public SubStringMatcher(String matcher) {
        this.matcher = NottableString.string(matcher);
    }

    public SubStringMatcher(NottableString matcher) {
        this.matcher = matcher;
    }

    public static boolean matches(String matcher, String matched, boolean ignoreCase) {
        boolean result = false;
        if (StringUtils.isEmpty(matcher)) {
            result = true;
        } else if (matched != null) {
            if (StringUtils.contains((CharSequence)matched, matcher)) {
                result = true;
            }
            if (ignoreCase && StringUtils.containsIgnoreCase(matched, matcher)) {
                result = true;
            }
        }
        return result;
    }

    @Override
    public boolean matches(String matched) {
        return this.matches(NottableString.string(matched));
    }

    @Override
    public boolean matches(NottableString matched) {
        boolean result = false;
        if (SubStringMatcher.matches(this.matcher.getValue(), matched.getValue(), false)) {
            result = true;
        }
        if (!result) {
            logger.trace("Failed to match [{}] with [{}]", (Object)matched, (Object)this.matcher);
        }
        return this.matcher.isNot() != this.reverseResultIfNot(result);
    }

    @Override
    public String[] fieldsExcludedFromEqualsAndHashCode() {
        return new String[]{"logger"};
    }
}

