/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import java.util.Arrays;
import java.util.List;
import org.mockserver.collections.CaseInsensitiveRegexMultiMap;
import org.mockserver.matchers.NotMatcher;
import org.mockserver.model.KeyToMultiValue;
import org.mockserver.model.KeysToMultiValues;

public class MultiValueMapMatcher
extends NotMatcher<List<KeyToMultiValue>> {
    private final CaseInsensitiveRegexMultiMap multiMap;

    public MultiValueMapMatcher(CaseInsensitiveRegexMultiMap multiMap) {
        this.multiMap = multiMap;
    }

    @Override
    public boolean matches(KeyToMultiValue ... values) {
        return this.matches(Arrays.asList(values));
    }

    @Override
    public boolean matches(List<KeyToMultiValue> values) {
        boolean result = false;
        if (this.multiMap == null) {
            result = true;
        } else if (KeysToMultiValues.toCaseInsensitiveRegexMultiMap(values).containsAll(this.multiMap)) {
            result = true;
        } else {
            this.logger.trace("Map [{}] is not a subset of {}", (Object)this.multiMap, (Object)values);
        }
        return this.reverseResultIfNot(result);
    }
}

