# NFV SOL005 APIs

This repository hosts the [OpenAPI](https://www.openapis.org/) specificatons and other documentation
for the APIs defined in ETSI NFV GSs SOL005 v3.6.1.

The APIs described in this repository are defined for the `Os-Ma-nfvo` reference point.

More information at [NFV Solutions wiki](https://nfvwiki.etsi.org/index.php?title=NFV_Solutions).

## Content structure

All the main OpenAPI files should be put in the `src` directory and organized with the following schema:

    src/deliverable-number/api-name/api-name.yaml
   
e.g.

    src/SOL005/NSDManagement/NSDManagement.yaml
   
   
## Building

The build file `.jenkins.sh` will validate the files, evaluate JSON references and store the generated files in the build directory. In case the build is executed by Jenkins, the merged file will be store in a specific directory to be web-served.

To build locally, once Docker is installed, simple run

    $ sudo bash .jenkins.sh
   
and the results will be stored in a `build/` directory in the project folder.

## How to raise issues

Change requests can be filed at [ETSI Forge Bugzilla](forge.etsi.org/bugzilla/buglist.cgi?component=Nfv-Openapis&list_id=62&product=NFV). Please report errors, bugs or other issues [here](https://forge.etsi.org/bugzilla/enter_bug.cgi?product=NFV).

## How to contribute

ETSI Forge uses Gitlab to manage submissions to the repository. Check the project page [here](https://forge.etsi.org/gitlab/nfv/SOL005).
More information is available [here](https://nfvwiki.etsi.org/index.php?title=SOL_OpenAPI_Main_Page#How_to_Contribute).

### Latest builds

See the recent builds from:

* [Master branch](https://forge.etsi.org/jenkins/job/NFV%20-%20Network%20Functions%20Virtualisation/job/sol005-master/)
* [Other branches](https://forge.etsi.org/jenkins/job/NFV%20-%20Network%20Functions%20Virtualisation/job/sol005/).

## License

Copyright (c) ETSI 2020.
 
This software is subject to copyrights owned by ETSI. Non-exclusive permission 
is hereby granted, free of charge, to copy, reproduce and amend this file 
under the following conditions: It is provided "as is", without warranty of any 
kind, expressed or implied. 

ETSI shall never be liable for any claim, damages, or other liability arising 
from its use or inability of use.This permission does not apply to any documentation 
associated with this file for which ETSI keeps all rights reserved. The present 
copyright notice shall be included in all copies of whole or part of this 
file and shall not imply any sub-license right.

