#!/bin/bash
# Copyright ETSI 2017
# See: https://forge.etsi.org/etsi-forge-copyright-statement.txt

if [ -n "$JOB_BASE_NAME" ] ; then 
  s="/var/www/html/api/nfv/$JOB_BASE_NAME/$GIT_COMMIT"
else
  s="${2:-`pwd`}"
fi 

f="${1:-`pwd`}"

mkdir -v -p "$s"

echo "Mounting dir $f as /work"
echo "Mounting dir $s as /storage"

docker run -v "$f":/work  -v "$s":/storage openapivalidator
