# NFV SOL002 and SOL003 APIs

This repository hosts the [OpenAPI](https://www.openapis.org/) specificatons and other documentation
for the APIs defined in ETSI NFV GSs [SOL002](http://www.etsi.org/deliver/etsi_gs/NFV-SOL/001_099/002/02.03.01_60/gs_NFV-SOL002v020301p.pdf) and [SOL003](http://www.etsi.org/deliver/etsi_gs/NFV-SOL/001_099/003/02.03.01_60/gs_NFV-SOL003v020301p.pdf).

The APIs described in this repository are defined for the following reference points:
* `Or-Vnfm`
* `Ve-vnfm`

More information at [NFV Solutions wiki](https://nfvwiki.etsi.org/index.php?title=NFV_Solutions).

## Content structure

All the main OpenAPI files should be put in the `src` directory and organized with the following schema:

   src/deliverable-number/api-name/api-name.yaml
   
e.g.

   src/SOL003/LifeCycleManagement/lifeCycleManagement.yaml
   
   
## Building

The build file `.jenkins.sh` will validate the files, evaluate JSON references and store the generated files in the build directory. In case the build is executed by Jenkins, the merged file will be store in a specific directory to be web-served.

To build locally, once Docker is installed, simple run

   $sudo bash .jenkins.sh
   
and the results will be stored in a `build/` directory in the project folder.

## How to raise issues

Change requests can be filed at [ETSI Forge Bugzilla](https://forge.etsi.org/bugzilla/enter_bug.cgi?product=NFV).

## How to contribute

Open and closed changes can be reviewed [here](https://forge.etsi.org/gerrit/#/q/project:NFV-SOL002-SOL003).

## Submit and review changes

See the recent builds [here](https://forge.etsi.org/jenkins/job/NFV%20-%20Network%20Functions%20Virtualisation/job/sol002-sol003/).

## License

Copyright (c) ETSI 2017.
 
This software is subject to copyrights owned by ETSI. Non-exclusive permission 
is hereby granted, free of charge, to copy, reproduce and amend this file 
under the following conditions: It is provided "as is", without warranty of any 
kind, expressed or implied. 

ETSI shall never be liable for any claim, damages, or other liability arising 
from its use or inability of use.This permission does not apply to any documentation 
associated with this file for which ETSI keeps all rights reserved. The present 
copyright notice shall be included in all copies of whole or part of this 
file and shall not imply any sub-license right.

