#!/env/python2.7

"""
Comments on gerrit
"""

import os.path
import subprocess
import glob

def mk_swg_ui_link(artifact, build_uri):
    """
      creates the link to the swagger ui
    """
    swg_ui = "https://forge.etsi.org/swagger/ui"
    return swg_ui + "/?url=" + build_uri + "/artifact/"+ artifact +"/*view*/"


def mk_swg_ui_comment(files, bu):
    """
      creates the link to the swagger ui
    """
    msg = "Review links for the built OpenAPIS:"
    for artifact in glob.glob(files):
        msg += "\n * " + os.path.basename(artifact) + ": " + mk_swg_ui_link(artifact, bu)
    return msg

def mk_grt_comment_cmd(change, payload):
    """
      creates the link to the swagger ui
    """
    command = "ssh -p 29418 forge.etsi.org \"gerrit review --message '"+payload+"'  "+change + "\""
    print command
    return command


def send_gerrit_comment(change, patchset):
    """
      creates the link to the swagger ui
    """
    cmd = mk_grt_comment_cmd(change, patchset)
    print "Executing: " + cmd
    subprocess.call(cmd, shell=True)

def jenkins_gerrit_comment(change_num, patch_num, comment):
    send_gerrit_comment(change_num+","+patch_num, comment)

def comment_openapis_artifacts(cn, pn, bu):
    comment = mk_swg_ui_comment("build/*-API.yaml", bu)
    # print "comment: "+comment
    jenkins_gerrit_comment(str(cn), str(pn), comment)