<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:template match="/">
        <vlans>
            <xsl:for-each select="nc:data/dot1q:bridges/dot1q:bridge/dot1q:component/dot1q:filtering-database/dot1q:vlan-registration-entry"
                        xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0"
                        xmlns:dot1q="urn:ieee:std:802.1Q:yang:ieee802-dot1q-bridge">
                <vlan>
                    <!--TODO: Includes additional fields as needed -->
                    <xsl:copy-of select="dot1q:vids" />
                    <xsl:variable name="vlan_id" select="dot1q:vids" />
                    <xsl:for-each select="./../../dot1q:bridge-vlan/dot1q:vlan" >
                        <xsl:if test="dot1q:vid=$vlan_id" >
                            <xsl:copy-of select="dot1q:name" />
                        </xsl:if>
                    </xsl:for-each>
                    <xsl:copy-of select="dot1q:entry-type" />
                    <port-left><xsl:value-of select="dot1q:port-map[1]/dot1q:port-ref" /></port-left>
                    <port-left-vlan-transmitted><xsl:value-of select="dot1q:port-map[1]/dot1q:static-vlan-registration-entries/dot1q:vlan-transmitted" /></port-left-vlan-transmitted>
                    <port-left-registrar-admin-control><xsl:value-of select="dot1q:port-map[1]/dot1q:static-vlan-registration-entries/dot1q:registrar-admin-control" /></port-left-registrar-admin-control>
                    <port-right><xsl:value-of select="dot1q:port-map[2]/dot1q:port-ref" /></port-right>
                    <port-right-vlan-transmitted><xsl:value-of select="dot1q:port-map[2]/dot1q:static-vlan-registration-entries/dot1q:vlan-transmitted" /></port-right-vlan-transmitted>
                    <port-right-registrar-admin-control><xsl:value-of select="dot1q:port-map[2]/dot1q:static-vlan-registration-entries/dot1q:registrar-admin-control" /></port-right-registrar-admin-control>
                </vlan>
            </xsl:for-each>
        </vlans>
    </xsl:template>
</xsl:stylesheet>
