<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:template match="/">
        <vlans>
            <xsl:for-each select="nc:data/dot1q:bridges/dot1q:bridge/dot1q:component/dot1q:filtering-database/dot1q:vlan-registration-entry"
                        xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0"
                        xmlns:dot1q="urn:ieee:std:802.1Q:yang:ieee802-dot1q-bridge">
                <!-- Vilmo proposal -->
                <xsl:for-each select="dot1q:port-map">
                    <vlan>
                        <xsl:copy-of select="../dot1q:name" />
                        <xsl:copy-of select="../dot1q:vids" />
                        <xsl:copy-of select="../dot1q:entry-type" />
                        <port-ref><xsl:value-of select="dot1q:port-ref" /></port-ref>
                        <vlan-transmitted><xsl:value-of select="dot1q:static-vlan-registration-entries/dot1q:vlan-transmitted" /></vlan-transmitted>
                        <registrar-admin-control><xsl:value-of select="dot1q:static-vlan-registration-entries/dot1q:registrar-admin-control" /></registrar-admin-control>
                    </vlan>
                </xsl:for-each>
            </xsl:for-each>
        </vlans>
    </xsl:template>
</xsl:stylesheet>
