<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:template match="/">
        <lldp>
            <xsl:for-each select="nc:data/lldp:lldp/lldp:port/lldp:remote-systems-data"
                        xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0"
                        xmlns:lldp="urn:ieee:std:802.1AB:yang:ieee802-dot1ab-lldp">
                <adjacency>

			<!-- Local Chassis Data -->

			<local-system-name><xsl:value-of select="../../lldp:local-system-data/lldp:system-name" /></local-system-name>
			<local-system-description><xsl:value-of select="../../lldp:local-system-data/lldp:system-description" /></local-system-description>

			<local-chassis-id-subtype><xsl:value-of select="../../lldp:local-system-data/lldp:chassis-id-subtype" /></local-chassis-id-subtype>
			<local-chassis-id><xsl:value-of select="../../lldp:local-system-data/lldp:chassis-id" /></local-chassis-id>

			<!-- Local Port Data -->

			<local-port-name><xsl:value-of select="../lldp:name" /></local-port-name>
			<local-port-desc><xsl:value-of select="../lldp:port-desc" /></local-port-desc>

			<local-port-id-subtype><xsl:value-of select="../lldp:port-id-subtype" /></local-port-id-subtype>
			<local-port-id><xsl:value-of select="../lldp:port-id" /></local-port-id>

			<local-port-dest-mac-address><xsl:value-of select="../lldp:dest-mac-address" /></local-port-dest-mac-address>
			<local-port-admin-status><xsl:value-of select="../lldp:admin-status" /></local-port-admin-status>

			<!-- Remote Chassis Data -->

			<remote-system-name><xsl:value-of select="lldp:system-name" /></remote-system-name>
			<remote-system-description><xsl:value-of select="lldp:system-description" /></remote-system-description>

			<remote-chassis-id-subtype><xsl:value-of select="lldp:chassis-id-subtype" /></remote-chassis-id-subtype>
			<remote-chassis-id><xsl:value-of select="lldp:chassis-id" /></remote-chassis-id>

			<!-- Remote Port Data -->
			<remote-port-desc><xsl:value-of select="lldp:port-desc" /></remote-port-desc>

			<remote-port-id-subtype><xsl:value-of select="lldp:port-id-subtype" /></remote-port-id-subtype>
			<remote-port-id><xsl:value-of select="lldp:port-id" /></remote-port-id>

			<!-- Ignored leaves: time-mark, remote-index, remote-too-many-neighbors, remote-changes -->
			<!-- system-capabilities-supported and system-capabilities-enabled -->
			<!-- Ignored: management-address, remote-unknown-tlv, remote-org-defined-info  -->
                </adjacency>
            </xsl:for-each>
        </lldp>
    </xsl:template>
</xsl:stylesheet>
