<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:template match="/">
        <interfaces>
            <xsl:for-each select="nc:data/if:interfaces/if:interface"
                        xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0"
                        xmlns:if="urn:ietf:params:xml:ns:yang:ietf-interfaces"
                        xmlns:ieee802-eth-if="urn:ieee:std:802.3:yang:ieee802-ethernet-interface">
                <interface>
                    <xsl:copy-of select="if:name" />
                    <xsl:copy-of select="if:type" />
                    <xsl:copy-of select="if:enabled" />
                    <xsl:copy-of select="if:if-index" />
                    <xsl:copy-of select="if:description" />
                    <xsl:copy-of select="if:admin-status" />
                    <xsl:copy-of select="if:oper-status" />
                    <xsl:copy-of select="if:phys-address" />
                    <xsl:copy-of select="if:speed" />
                    <xsl:copy-of select="ieee802-eth-if:ethernet/ieee802-eth-if:duplex" />
                    <configured-speed><xsl:value-of select="ieee802-eth-if:ethernet/ieee802-eth-if:speed" /></configured-speed>
                    <auto-negotiation><xsl:value-of select="ieee802-eth-if:ethernet/ieee802-eth-if:auto-negotiation/ieee802-eth-if:enable" /></auto-negotiation>
                    <xsl:copy-of select="ieee802-eth-if:ethernet/ieee802-eth-if:auto-negotiation/ieee802-eth-if:negotiation-status" />
                    <!-- Ignored if leaves: link-up-down-trap-enable, last-change, if-index, higher-layer-if, lower-layer-if -->
                    <!-- Ignored if container: statistics -->
                </interface>
            </xsl:for-each>
        </interfaces>
    </xsl:template>
</xsl:stylesheet>
