<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:template match="/">
        <interfaces>
            <xsl:for-each select="nc:data/if:interfaces/if:interface"
                        xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0"
                        xmlns:if="urn:ietf:params:xml:ns:yang:ietf-interfaces"
                        xmlns:mrl="urn:ietf:params:xml:ns:yang:ietf-microwave-radio-link">
                <interface>
                    <xsl:copy-of select="if:name" />
                    <xsl:copy-of select="if:type" />
                    <xsl:copy-of select="if:enabled" />
                    <xsl:copy-of select="if:if-index" />
                    <xsl:copy-of select="if:description" />
                    <xsl:copy-of select="if:admin-status" />
                    <xsl:copy-of select="if:oper-status" />
                    <xsl:copy-of select="if:phys-address" />
                    <xsl:copy-of select="if:speed" />
                    <xsl:copy-of select="mrl:carrier-id" />
                    <xsl:copy-of select="mrl:tx-enabled" />
                    <xsl:copy-of select="mrl:tx-oper-status" />
                    <xsl:copy-of select="mrl:tx-frequency" />
                    <xsl:copy-of select="mrl:rx-frequency" />
                    <xsl:copy-of select="mrl:duplex-distance" />
                    <xsl:copy-of select="mrl:actual-rx-frequency" />
                    <xsl:copy-of select="mrl:actual-duplex-distance" />
                    <xsl:copy-of select="mrl:channel-separation" />
                    <xsl:copy-of select="mrl:polarization" />
                    <xsl:copy-of select="mrl:actual-tx-cm" />
                    <xsl:copy-of select="mrl:actual-snir" />
                    <xsl:copy-of select="mrl:actual-xpi" />
                    <xsl:copy-of select="mrl:actual-transmitted-level" />
                    <xsl:copy-of select="mrl:actual-received-level" />
                    <!--  get what is inside a child attribute (ex: mrl:maximum-nominal-power is inside mrl:rtpc)  -->
                    <xsl:copy-of select="mrl:rtpc/mrl:maximum-nominal-power" />
                    <xsl:copy-of select="mrl:atpc/mrl:maximum-nominal-power" />
                    <xsl:copy-of select="mrl:atpc/mrl:atpc-lower-threshold" />
                    <xsl:copy-of select="mrl:atpc/mrl:atpc-upper-threshold" />
                    <xsl:copy-of select="mrl:single/mrl:selected-cm" />
                    <xsl:copy-of select="mrl:adaptive/mrl:selected-min-acm" />
                    <xsl:copy-of select="mrl:adaptive/mrl:selected-max-acm" />
                    <xsl:copy-of select="mrl:capabilities/mrl:available-min-acm" />
                    <xsl:copy-of select="mrl:capabilities/mrl:available-max-acm" />

                    <!-- Numerous mrl leaves are ignored -->
                    <!-- Ignored if leaves: link-up-down-trap-enable, last-change, if-index, higher-layer-if, lower-layer-if -->
                    <!-- Ignored if container: statistics -->
                </interface>
            </xsl:for-each>
        </interfaces>
    </xsl:template>
</xsl:stylesheet>
