*** Settings ***
Library           JSONSchemaLibrary    schemas/
Resource          environment/variables.txt    # Generic Parameters
Resource          NSDManagementKeywords.robot
Library           JSONLibrary
Library           REST    ${NFVO_SCHEMA}://${NFVO_HOST}:${NFVO_PORT}    ssl_verify=false
Library           OperatingSystem

*** Test Cases ***
Get PNFD Archive Manifest
    [Documentation]    Test ID: 5.3.1.14.1
    ...    Test title: Get PNFD Archive Manifest
    ...    Test objective: The objective is to test that GET method reads the content of the manifest file within an PNFD archive
    ...    Pre-conditions: One or more PNFDs are onboarded in the NFVO.
    ...    Reference: Clause 5.4.7b.3.2 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get PNFD Archive Manifest
    Check HTTP Response Status Code Is    200
    Check HTTP Response Header Content-Type Is    text/plain
    
Get PNFD Archive Manifest with security information
    [Documentation]    Test ID: 5.3.1.14.2
    ...    Test title: Get PNFD Archive Manifest with security information
    ...    Test objective: The objective is to test the retrieval of content of the manifest file within an PNFD archive shall include in the ZIP archive the security information when requested with "include_signature" parameter
    ...    Pre-conditions: One or more PNFDs are onboarded in the NFVO.
    ...    Reference: Clause 5.4.7b.3.2 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get PNFD Archive Manifest with security information
    Check HTTP Response Status Code Is    200
    Check HTTP Response Header Content-Type Is    application/zip
    
Get PNFD Archive Manifest with conflict due to onboarding state
    [Documentation]    Test ID: 5.3.1.14.3
    ...    Test title: Get PNFD Archive Manifest with conflict due to onboarding state
    ...    Test objective: The objective is to test that the retrieval of content of the manifest file within an PNFD archive fails due to a conflict when the PNFD is not in onboarding state ONBOARDED in the NFVO. The test also performs a validation of the JSON schema validation of the failed operation HTTP response
    ...    Pre-conditions: The onboarding state of the PNFD is different from ONBOARDED.
    ...    Reference: Clause 5.4.7b.3.2 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none 
    Get PNFD Archive Manifest with conflict due to onboarding state
    Check HTTP Response Status Code Is    409
    Check HTTP Response Body Json Schema Is   ProblemDetails  
    
POST PNFD Archive Manifest - Method not implemented
    [Documentation]    Test ID: 5.3.1.14.4
    ...    Test title: POST PNFD Archive Manifest - Method not implemented
    ...    Test objective: The objective is to test that POST method is not allowed to create a new Network Service Descriptor Archive Manifest
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.7b.3.1 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send POST Request for PNFD Archive Manifest
    Check HTTP Response Status Code Is    405
    
PUT PNFD Archive Manifest - Method not implemented
    [Documentation]    Test ID: 5.3.1.14.5
    ...    Test title: PUT PNFD Archive Manifest - Method not implemented
    ...    Test objective: The objective is to test that PATCH method is not allowed to update Network Service Descriptor Archive Manifest
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.7b.3.3 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send PUT Request for PNFD Archive Manifest
    Check HTTP Response Status Code Is    405

PATCH PNFD Archive Manifest - Method not implemented
    [Documentation]    Test ID: 5.3.1.14.6
    ...    Test title: PATCH PNFD Archive Manifest - Method not implemented
    ...    Test objective: The objective is to test that PATCH method is not allowed to update Network Service Descriptor Archive Manifest
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.7b.3.4 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send PATCH Request for PNFD Archive Manifest
    Check HTTP Response Status Code Is    405

DELETE PNFD Archive Manifest - Method not implemented
    [Documentation]    Test ID: 5.3.1.14.7
    ...    Test title: DELETE PNFD Archive Manifest - Method not implemented
    ...    Test objective: The objective is to test that DELETE method is not allowed to delete Network Service Descriptor Archive Manifest
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.7b.3.5 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send DELETE Request for PNFD Archive Manifest
    Check HTTP Response Status Code Is    405