*** Settings ***
Resource    NFVICapacityInformationKeywords.robot

*** Test Cases ***
POST NFVI Capacity Information - Method not implemented
    [Documentation]    Test ID: 5.3.6.2.1
    ...    Test title: POST NFVI Capacity Information - Method not implemented
    ...    Test objective: The objective is to test that POST method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 10.4.2.3.1 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    POST NFVI Capacity Information
    Check HTTP Response Status Code Is    405

GET NFVI Capacity Information  
    [Documentation]    Test ID: 5.3.6.2.2
    ...    Test title: GET NFVI Capacity Information
    ...    Test objective: The objective is to GET NFVI Capacity Information objects
    ...    Pre-conditions: none
    ...    Reference: Clause 10.4.2.3.2 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET NFVI Capacity Information
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    NfviCapacityInfos

GET NFVI Capacity Information - Filter
    [Documentation]    Test ID: 5.3.6.2.3
    ...    Test title: GET NFVI Capacity Information - Filter
    ...    Test objective: The objective is to GET NFVI Capacity Information objects using filter
    ...    Pre-conditions: none
    ...    Reference: Clause 10.4.2.3.2 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET NFVI Capacity Information with filter
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    NfviCapacityInfos
    
GET NFVI Capacity Information Bad Request Invalid attribute-based filtering parameters
    [Documentation]    Test ID: 5.3.6.2.4
    ...    Test title: GET NFVI Capacity Information Bad Request Invalid attribute-based filtering parameters
    ...    Test objective: The objective is to get information about NFVI Capacity Information with Invalid attribute-based filtering parameters
    ...    Pre-conditions: none
    ...    Reference: Clause 10.4.2.3.2 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET NFVI Capacity Information with bad attribute
    Check HTTP Response Status Code Is    400
    Check HTTP Response Body Json Schema Is   ProblemDetails

GET NFVI Capacity Information Bad Request Invalid attribute selector
    [Documentation]    Test ID: 5.3.6.2.5
    ...    Test title: GET NFVI Capacity Information Bad Request Invalid attribute selector
    ...    Test objective: The objective is to get information about NFVI Capacity Information with Invalid attribute selector
    ...    Pre-conditions: none
    ...    Reference: Clause 10.4.2.3.2 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET NFVI Capacity Information with bad filter
    Check HTTP Response Status Code Is    400
    Check HTTP Response Body Json Schema Is   ProblemDetails

GET NFVI Capacity Information with "all_fields" attribute selector
    [Documentation]    Test ID: 5.3.6.2.6
    ...    Test title: GET NFVI Capacity Information with "all_fields" attribute selector
    ...    Test objective: The objective is to query NFVI Capacity Information with "all_fields" attribute selector
    ...    Pre-conditions:  none
    ...    Reference: Clause 10.4.2.3.2 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET NFVI Capacity Information with all_fields attribute selector
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    NfviCapacityInfos

GET NFVI Capacity Information with "exclude_default" attribute selector
    [Documentation]    Test ID: 5.3.6.2.7
    ...    Test title: GET NFVI Capacity Information with "exclude_default" attribute selector
    ...    Test objective: The objective is to query NFVI Capacity Information with "exclude_default" attribute selector
    ...    Pre-conditions:  none
    ...    Reference: Clause 10.4.2.3.2 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET NFVI Capacity Information with exclude_default attribute selector
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    NfviCapacityInfos
    
GET NFVI Capacity Information with "fields" attribute selector
    [Documentation]    Test ID: 5.3.6.2.8
    ...    Test title: GET NFVI Capacity Information with "fields" attribute selector
    ...    Test objective: The objective is to query NFVI Capacity Information with "fields" attribute selector
    ...    Pre-conditions:  none
    ...    Reference: Clause 10.4.2.3.2 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET NFVI Capacity Information with fields attribute selector
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    NfviCapacityInfos

GET NFVI Capacity Information with "exclude_default" and "fields" attribute selector
    [Documentation]    Test ID: 5.3.6.2.9
    ...    Test title: GET NFVI Capacity Information with "exclude_default" and "fields" attribute selector
    ...    Test objective: The objective is to query NFVI Capacity Information with "exclude_default" and "fields" attribute selector
    ...    Pre-conditions:  none
    ...    Reference: Clause 10.4.2.3.2 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET NFVI Capacity Information with exclude_default and fields attribute selector
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    NfviCapacityInfos
    
GET NFVI Capacity Information with "exclude_fields" attribute selector
    [Documentation]    Test ID: 5.3.6.2.10
    ...    Test title: GET NFVI Capacity Information with "exclude_fields" attribute selector
    ...    Test objective: The objective is to query NFVI Capacity Information with "exclude_fields" attribute selector
    ...    Pre-conditions:  none
    ...    Reference: Clause 10.4.2.3.2 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET NFVI Capacity Information with exclude_fields attribute selector
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    NfviCapacityInfos  
    
GET NFVI Capacity Information - Bad Request Response too Big
    [Documentation]    Test ID: 5.3.6.2.11
    ...    Test title: GET NFVI Capacity Information - Bad Request Response too Big
    ...    Test objective: The objective is test that the retrieval of existing NFVI Capacity Information list fails because response is too big, and perform the JSON schema validation of the failed operation HTTP response.
    ...    Pre-conditions: none
    ...    Reference: Clause 10.4.2.3.2 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: NFVO does not support paged response.
    ...    Post-Conditions: none 
    GET NFVI Capacity Information without Paging support
    Check HTTP Response Status Code Is    400
    Check HTTP Response Body Json Schema Is    ProblemDetails

GET NFVI Capacity Information as Paged Response
    [Documentation]    Test ID: 5.3.6.2.12
    ...    Test title: GET NFVI Capacity Information as Paged Response
    ...    Test objective: The objective is to test that GET method retrieves the list of existing NFVI Capacity Information as paged response.
    ...    Pre-conditions: none
    ...    Reference: Clause 10.4.2.3.2 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: NFVO supports paged response.
    ...    Post-Conditions: none    
    GET NFVI Capacity Information with Paging support
    Check HTTP Response Status Code Is  200
    Check HTTP Response Header Contains Link
        
PUT NFVI Capacity Information - Method not implemented
    [Documentation]    Test ID: 5.3.6.2.13
    ...    Test title: PUT NFVI Capacity Information - Method not implemented
    ...    Test objective: The objective is to test that PUT method is not implemented
    ...    Pre-conditions:  none
    ...    Reference: Clause 10.4.2.3.3 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    PUT NFVI Capacity Information
    Check HTTP Response Status Code Is    405

PATCH NFVI Capacity Information - Method not implemented
    [Documentation]    Test ID: 5.3.6.2.14
    ...    Test title: PATCH NFVI Capacity Information - Method not implemented
    ...    Test objective: The objective is to test that PATCH method is not implemented
    ...    Pre-conditions: none 
    ...    Reference: Clause 10.4.2.3.4 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    PATCH NFVI Capacity Information
    Check HTTP Response Status Code Is    405

DELETE NFVI Capacity Information - Method not implemented
    [Documentation]    Test ID: 5.3.6.2.15
    ...    Test title: DELETE NFVI Capacity Information - Method not implemented
    ...    Test objective: The objective is to test that DELETE method is not implemented
    ...    Pre-conditions: none 
    ...    Reference: Clause 10.4.2.3.5 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    DELETE NFVI Capacity Information
    Check HTTP Response Status Code Is    405
