*** Settings ***
Resource    environment/variables.txt  
Library     REST    ${NFVO_SCHEMA}://${NFVO_HOST}:${NFVO_PORT}     ssl_verify=false
Library     DependencyLibrary
Library     JSONLibrary
Library     JSONSchemaLibrary    schemas/
Library     OperatingSystem
Library     String

*** Keywords ***
POST API Version
    Set Headers    {"Accept":"${ACCEPT_JSON}"} 
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Post    ${apiRoot}/${apiName}/api_versions
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
	
GET API Version
    Set Headers    {"Accept":"${ACCEPT_JSON}"} 
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/api_versions
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
	
PUT API Version
    Set Headers    {"Accept":"${ACCEPT_JSON}"} 
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Put    ${apiRoot}/${apiName}/api_versions
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
	
PATCH API Version
    Set Headers    {"Accept":"${ACCEPT_JSON}"} 
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Patch    ${apiRoot}/${apiName}/api_versions
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
	
DELETE API Version
    Set Headers    {"Accept":"${ACCEPT_JSON}"} 
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Delete    ${apiRoot}/${apiName}/api_versions
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
	
POST API Version with apiMajorVersion
    Set Headers    {"Accept":"${ACCEPT_JSON}"} 
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/api_versions
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
	
GET API Version with apiMajorVersion
    Set Headers    {"Accept":"${ACCEPT_JSON}"} 
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/api_versions
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
	
PUT API Version with apiMajorVersion
    Set Headers    {"Accept":"${ACCEPT_JSON}"} 
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/api_versions
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
	
PATCH API Version with apiMajorVersion
    Set Headers    {"Accept":"${ACCEPT_JSON}"} 
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/api_versions
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
	
DELETE API Version with apiMajorVersion
    Set Headers    {"Accept":"${ACCEPT_JSON}"} 
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Delete    ${apiRoot}/${apiName}/${apiMajorVersion}/api_versions
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
	
	
Check HTTP Response Status Code Is
    [Arguments]    ${expected_status}    
    Should Be Equal As Strings   ${response['status']}    ${expected_status}
    Log    Status code validated 

Check HTTP Response Body Json Schema Is
    [Arguments]    ${input}
    ${schema} =    Catenate    SEPARATOR=    ${input}    .schema.json
    Validate Json    ${schema}    ${response['body']}
    Log    Json Schema Validation OK

POST NFVI Capacity Information
    Log    Trying to perform a POST. This method should not be implemented.
    Set Headers    {"Accept":"${ACCEPT_JSON}"} 
    Set Headers    {"Content-Type":"${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/nfvi_capacity_infos
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}        
	
GET NFVI Capacity Information	
    Log    The GET method queries information about NFVI Capacity Information.
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/nfvi_capacity_infos 
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 		

GET NFVI Capacity Information with filter
    Log    The GET method queries information about NFVI Capacity Information.
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/nfvi_capacity_infos?${POS_FILTER}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 		

GET NFVI Capacity Information with bad attribute	
    Log    The GET method queries information about NFVI Capacity Information.
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"} 
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/nfvi_capacity_infos?attribute_not_exist=some_value
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 	

GET NFVI Capacity Information with bad filter	
    Log    The GET method queries information about NFVI Capacity Information.
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"} 
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/nfvi_capacity_infos?fields=wrong_field
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 	
	
GET NFVI Capacity Information with all_fields attribute selector
    Log    Query status information about NFVI Capacity Information, using fields
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/nfvi_capacity_infos?all_fields
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
GET NFVI Capacity Information with exclude_default attribute selector
    Log    Query status information about NFVI Capacity Information using fields
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/nfvi_capacity_infos?exclude_default
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
GET NFVI Capacity Information with fields attribute selector
    Log    Query status information about NFVI Capacity Information, using fields
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/nfvi_capacity_infos?fields=${fields}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}	    
    
GET NFVI Capacity Information with exclude_default and fields attribute selector
    Log    Query status information about NFVI Capacity Information, using fields
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/nfvi_capacity_infos?fields=${fields}&exclude_default
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
GET NFVI Capacity Information with exclude_fields attribute selector
    Log    Query status information about NFVI Capacity Information, using fields
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/nfvi_capacity_infos?exclude_fields=${fields}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output} 	

GET NFVI Capacity Information without Paging support
    Run Keyword If    ${PAGING_SUPPORTED} == 0    GET NFVI Capacity Information
    
GET NFVI Capacity Information with Paging support
    Run Keyword If    ${PAGING_SUPPORTED} == 1    GET NFVI Capacity Information

Check HTTP Response Header Contains Link
    ${linkURL}=    Get Value From Json    ${response['headers']}    $..Link
    Should Not Be Empty    ${linkURL}

PUT NFVI Capacity Information
    log    Trying to perform a PUT. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/nfvi_capacity_infos   	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
PATCH NFVI Capacity Information
    Log    Trying to perform a PATCH. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/nfvi_capacity_infos	 	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
DELETE NFVI Capacity Information
    Log    Trying to perform a DELETE. This method should not be implemented
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Delete    ${apiRoot}/${apiName}/${apiMajorVersion}/nfvi_capacity_infos	 	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}   

POST Individual VIMs NFVI Capacity Information
    log    Trying to perform a POST. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/nfvi_capacity_infos/${vimId}    
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}        

GET Individual VIMs NFVI Capacity Information
    log    Trying to get information about an Individual VIMs NFVI Capacity Information
    Set Headers    {"Accept":"${ACCEPT_JSON}"}  
    Set Headers    {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/nfvi_capacity_infos/${vimId} 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}      

GET Individual VIMs NFVI Capacity Information using filter
    log    Trying to get information about an Individual VIMs NFVI Capacity Information
    Set Headers    {"Accept":"${ACCEPT_JSON}"}  
    Set Headers    {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/nfvi_capacity_infos/${vimId}?${POS_FILTER}		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}      

GET Individual VIMs NFVI Capacity Information with Invalid VIM ID
    log    Trying to get information about an Individual VIMs NFVI Capacity Information
    Set Headers    {"Accept":"${ACCEPT_JSON}"}  
    Set Headers    {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${invalidVimId} 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}      
	
PUT Individual VIMs NFVI Capacity Information
    log    Trying to perform a PUT. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/nfvi_capacity_infos/${vimId} 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 

PATCH Individual VIMs NFVI Capacity Information
    log    Trying to perform a PATCH. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/nfvi_capacity_infos/${vimId} 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 

DELETE Individual VIMs NFVI Capacity Information
    log    Trying to perform a DELETE. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/nfvi_capacity_infos/${vimId} 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 

POST Create a Capacity Threshold
    Log    Trying to POST create a new capacity threshold.
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${template}=    Get File    jsons/CreateCapacityThresholdRequest.json
    ${body}=    Format String    ${template}    callback_uri=${callback_uri} 
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/capacity_thresholds    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}      

POST Create a Capacity Threshold - Unreachable URI
    Log    Trying to POST create a new capacity threshold using an unreachable callbackUri in the request body
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${template}=    Get File    jsons/CreateCapacityThresholdRequest.json
    ${body}=    Format String    ${template}    callback_uri=${unreachable_callback_uri} 
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/capacity_thresholds    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}      
    
Check HTTP Response Contains Resource URI
    ${ResourceURI}=    Get Value From Json    ${response['headers']}    $..Location
    Should Not Be Empty    ${ResourceURI}

GET Capacity Thresholds
    log    Trying to get information about multiple Capacity Thresholds
    Set Headers    {"Accept":"${ACCEPT_JSON}"}  
    Set Headers    {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/capacity_thresholds	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}    

GET Capacity Thresholds using filter
    log    Trying to get information about multiple Capacity Thresholds using filtering parameters
    Set Headers    {"Accept":"${ACCEPT_JSON}"}  
    Set Headers    {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/capacity_thresholds?${POS_FILTER}		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}    

GET Capacity Thresholds using invalid filter
    log    Trying to get information about multiple Capacity Thresholds using invalid filtering parameters
    Set Headers    {"Accept":"${ACCEPT_JSON}"}  
    Set Headers    {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/capacity_thresholds?${NEG_FILTER}		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}    

GET Capacity Thresholds without Paging support
    Run Keyword If    ${PAGING_SUPPORTED} == 0    GET Capacity Thresholds
    
GET Capacity Thresholds with Paging support
    Run Keyword If    ${PAGING_SUPPORTED} == 1    GET Capacity Thresholds
    
PUT Capacity Thresholds
    log    Trying to perform a PUT. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/capacity_thresholds 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 

PATCH Capacity Thresholds
    log    Trying to perform a PATCH. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/capacity_thresholds 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 

DELETE Capacity Thresholds
    log    Trying to perform a DELETE. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/capacity_thresholds 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
	
POST Individual Capacity Threshold
    log    Trying to perform a POST. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/capacity_thresholds/${capacityThreshold}    
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}        

GET Individual Capacity Threshold
    log    Trying to get information about an Individual Capacity Threshold
    Set Headers    {"Accept":"${ACCEPT_JSON}"}  
    Set Headers    {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/capacity_thresholds/${capacityThreshold}  		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}      
	
GET Individual Capacity Threshold - Invalid URI
    log    Trying to get information about an Individual Capacity Threshold
    Set Headers    {"Accept":"${ACCEPT_JSON}"}  
    Set Headers    {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/capacity_thresholds/${invalid_capacityThreshold}  		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}      

PUT Individual Capacity Threshold
    log    Trying to perform a PUT. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/capacity_thresholds/${capacityThreshold} 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
	
PATCH Individual Capacity Threshold
    log    Trying to perform a PATCH to modify callback URI for an individual Capacity Threshold
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_PATCH}"}
    Set Headers    {"If-Match": "${original_etag}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${template} =    Get File    jsons/CapacityThresholdModificationRequest.json
    ${body}=        Format String   ${template}     callback_uri=${new_callback_uri}
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/capacity_thresholds/${capacityThreshold}    ${body} 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 

PATCH Individual Capacity Threshold - ETag mismatch
    log    Trying to perform a PATCH to modify individual VNF snapshot
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_PATCH}"}
    Set Headers    {"If-Match": "${invalid_etag}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${template} =    Get File    jsons/CapacityThresholdModificationRequest.json
    ${body}=        Format String   ${template}     callback_uri=${new_callback_uri}
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/capacity_thresholds/${capacityThreshold}    ${body} 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 

PATCH Individual Capacity Threshold - Unreachable CallbackURI
    log    Trying to perform a PATCH to modify individual VNF snapshot
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_PATCH}"}
    Set Headers    {"If-Match": "${invalid_etag}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${template} =    Get File    jsons/CapacityThresholdModificationRequest.json
    ${body}=        Format String   ${template}     callback_uri=${unreachable_callback_uri}
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/capacity_thresholds/${capacityThreshold}    ${body} 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 

DELETE Individual Capacity Threshold
    log    Trying to DELETE an Individual Capacity Threshold
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Delete    ${apiRoot}/${apiName}/${apiMajorVersion}/capacity_thresholds/${capacityThreshold}  		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 

Check Postcondition resource is deleted
    GET Individual Capacity Threshold
    Check HTTP Response Status Code Is    404
    
Check resource existence and get CallbackUri
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/capacity_thresholds/${capacityThreshold}  		
    Integer    response status    200
    Validate Json    response body    CapacityThreshold.schema.json
    Set Global Variable    ${callbackResp}    response body callbackUri

POST Capacity Shortage Notification
    log    Trying to perform a POST to deliver notification.
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${body} =    Get File    jsons/CapacityShortageNotification.json  
    Post    ${callbackResp}    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
GET reach the notification endpoint  
    Log    Trying to reach the notification endpoint using GET method.
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${callbackResp}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}

GET reach an unreachable notification endpoint  
    Log    Trying to reach the notification endpoint using GET method.
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${unreachable_callbackuri}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}

PUT notification endpoint  
    Log    Trying to perform a PUT. This method should not be implemented.
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Put    ${callbackResp}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}

PATCH notification endpoint  
    Log    Trying to perform a PATCH. This method should not be implemented.
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Patch    ${callbackResp}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}

DELETE notification endpoint  
    Log    Trying to perform a DELETE. This method should not be implemented.
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Delete    ${callbackResp}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
