/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.BodyMatcher;
import org.mockserver.model.HttpRequest;
import org.mockserver.validator.jsonschema.JsonSchemaValidator;

public class JsonSchemaMatcher
extends BodyMatcher<String> {
    private static final String[] excludedFields = new String[]{"mockServerLogger", "jsonSchemaValidator"};
    private final MockServerLogger mockServerLogger;
    private String schema;
    private JsonSchemaValidator jsonSchemaValidator;

    public JsonSchemaMatcher(MockServerLogger mockServerLogger, String schema) {
        this.mockServerLogger = mockServerLogger;
        this.schema = schema;
        this.jsonSchemaValidator = new JsonSchemaValidator(mockServerLogger, schema);
    }

    @Override
    public boolean matches(HttpRequest context, String matched) {
        boolean result = false;
        try {
            String validation = this.jsonSchemaValidator.isValid(matched);
            result = validation.isEmpty();
            if (!result) {
                this.mockServerLogger.trace(context, "Failed to match JSON: {}with schema: {}because: {}", matched, this.schema, validation);
            }
        }
        catch (Exception e) {
            this.mockServerLogger.trace(context, "Failed to match JSON: {}with schema: {}because: {}", matched, this.schema, e.getMessage());
        }
        return this.not != result;
    }

    @Override
    @JsonIgnore
    protected String[] fieldsExcludedFromEqualsAndHashCode() {
        return excludedFields;
    }
}

