*** Settings ***
Resource    environment/variables.txt 
Suite Setup    Create Sessions
Suite Teardown    Terminate All Processes    kill=true
Library    MockServerLibrary
Library    Process
Library    OperatingSystem
Library    Collections

*** Test Cases ***
Virtualised Resource Quota Available Notification
    [Documentation]    Test ID: 7.3.7.5.1
    ...    Test title: Virtualised Resource Quota Available Notification
    ...    Test objective: The objective is to test the dispatch of Virtualised Resource Quota Available Notification, and perform a JSON schema and content validation of the delivered notification. The action that triggers the notification under test is an explicit test step, but it is not performed by the test system.
    ...    Pre-conditions: A subscription for Virtualised Resource Quota Available Notification is available in the VNFM.
    ...    Reference: Clause 11.4.4.3.1 - ETSI GS NFV-SOL 003 [1] v3.6.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none 
    Trigger a dispatch of virtualised resource quota available notification (external action) 
    Check Virtualised Resource Quota Available Notification Http POST Request Body Json Schema Is    VrQuotaAvailNotification
    Check Virtualised Resource Quota Available Notification Http POST Request Body notificationType attribute Is    VrQuotaAvailNotification
   
*** Keywords ***

Trigger a dispatch of virtualised resource quota available notification (external action) 
    #do nothing
    Log    do nothing  
    
Check Virtualised Resource Quota Available Notification Http POST Request Body Json Schema Is  
    [Arguments]    ${element}
    ${schema}=	Get File	schemas/${element}.schema.json
    Configure Notification Forward    ${schema}    ${callback_endpoint}    ${callback_endpoint_fwd}

Check Virtualised Resource Quota Available Notification Http POST Request Body notificationType attribute Is
    [Arguments]    ${type}
    Configure Virtual Quota Available Notification Handler    ${callback_endpoint_fwd}    ${type}
    Wait Until Keyword Succeeds    2 min   10 sec   Verify Mock Expectation    ${notification_request}
    Clear Requests    ${callback_endpoint}
    Clear Requests    ${callback_endpoint_fwd}
    
Configure Virtual Quota Available Notification Handler
    [Arguments]    ${endpoint}    ${type}
    ${json}=    evaluate    {}
    set to dictionary   ${json}    notificationType    ${type}
    ${BODY}=    evaluate    json.dumps(${json})    json
    Log  Creating mock request and response to handle status notification
    &{req}=  Create Mock Request Matcher	POST  ${endpoint}  body_type="JSON"    body=${BODY}
    Set Global Variable    ${notification_request}    ${req}
    &{notification_response}=  Create Mock Response    status_code=204
    Create Mock Expectation  ${notification_request}  ${notification_response}
    
Configure Notification Forward
    [Arguments]    ${schema}    ${endpoint}    ${endpoint_fwd}    
    Log  Creating mock Http POST forward to handle ${schema}
    &{notification_tmp}=  Create Mock Request Matcher	POST  ${endpoint}  body_type="JSON_SCHEMA"    body=${schema}
    &{notification_fwd}=  Create Mock Http Forward	${endpoint_fwd}
    Create Mock Expectation With Http Forward  ${notification_tmp}  ${notification_fwd}

Create Sessions
    Start Process  java  -jar  ${MOCK_SERVER_JAR}  -serverPort  ${callback_port}  alias=mockInstance
    Wait For Process  handle=mockInstance  timeout=5s  on_timeout=continue
    Create Mock Session  ${callback_uri}:${callback_port}
