*** Settings ***
Resource    environment/variables.txt 
Resource    VnfLcmOperationKeywords.robot
Library    REST    ${VNFM_SCHEMA}://${VNFM_HOST}:${VNFM_PORT}     ssl_verify=false
Library    DependencyLibrary
Library    JSONLibrary
Library    JSONSchemaLibrary    schemas/
Documentation    This task resource represents the "Retry operation" operation. The client can use this resource to initiate retrying a VNF lifecycle operation.
Suite Setup    Check resource existence

*** Test Cases ***
POST Retry operation task  
    [Documentation]    Test ID: 6.3.5.13.1
    ...    Test title: POST Retry operation task
    ...    Test objective: The objective is to test that POST method The POST method initiates retrying a VNF lifecycle operation if that operation has experienced a temporary failure
    ...    Pre-conditions: the "VNF LCM operation occurrence" resource is in "FAILED_TEMP" state.
    ...    Reference: Clause 5.4.14.3.1 - ETSI GS NFV-SOL 002 [2] v3.6.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none
    ...    Post-Conditions: none 
    Post Retry operation
    Check HTTP Response Status Code Is    202
    Check Operation Occurrence Id

POST Retry operation task Conflict (Not-FAILED_TEMP)
    [Documentation]    Test ID: 6.3.5.13.2
    ...    Test title: POST Retry operation task Conflict (Not-FAILED_TEMP)
    ...    Test objective: The objective is to test that the retry operation cannot be executed currently, due to a conflict with the state of the VNF instance resource. (i.e. the VNF instance resource is not in FAILED_TEMP state)
    ...    Pre-conditions: the "VNF LCM operation occurrence" resource is not in "FAILED_TEMP" state.
    ...    Reference: Clause 5.4.14.3.1 - ETSI GS NFV-SOL 002 [2] v3.6.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none
    ...    Post-Conditions: none 
    Post Retry operation
    Check HTTP Response Status Code Is    409
    Check HTTP Response Body Json Schema Is    ProblemDetails

POST Retry operation task Not Found
    [Documentation]    Test ID: 6.3.5.13.3
    ...    Test title: POST Retry operation task Not Found
    ...    Test objective: The objective is to test that the retry operation cannot be executed because the operation is not supported
    ...    Pre-conditions: 
    ...    Reference: Clause 5.4.14.3.1 - ETSI GS NFV-SOL 002 [2] v3.6.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none
    ...    Post-Conditions: none 
    Post Retry operation
    Check HTTP Response Status Code Is    404
    Check HTTP Response Body Json Schema Is    ProblemDetails

GET Retry operation task - Method not implemented
    [Documentation]    Test ID: 6.3.5.13.4
    ...    Test title: GET Retry operation task- Method not implemented
    ...    Test objective: The objective is to verify that the method is not implemented 
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.14.2 - ETSI GS NFV-SOL 002 [2] v3.6.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none
    ...    Post-Conditions: none
    Get Retry operation
    Check HTTP Response Status Code Is    405

PUT Retry operation task - Method not implemented
    [Documentation]    Test ID: 6.3.5.13.5
    ...    Test title: PUT Retry operation task- Method not implemented
    ...    Test objective: The objective is to verify that the method is not implemented 
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.14.3 - ETSI GS NFV-SOL 002 [2] v3.6.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none
    ...    Post-Conditions: none
    Put Retry operation
    Check HTTP Response Status Code Is    405

PATCH Retry operation task - Method not implemented
    [Documentation]    Test ID: 6.3.5.13.6
    ...    Test title: PATCH Retry operation task- Method not implemented
    ...    Test objective: The objective is to verify that the method is not implemented 
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.14.4 - ETSI GS NFV-SOL 002 [2] v3.6.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none
    ...    Post-Conditions: none
    Patch Retry operation
    Check HTTP Response Status Code Is    405
    
DELETE Retry operation task - Method not implemented
    [Documentation]    Test ID: 6.3.5.13.7
    ...    Test title: DELETE Retry operation task- Method not implemented
    ...    Test objective: The objective is to verify that the method is not implemented 
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.14.5 - ETSI GS NFV-SOL 002 [2] v3.6.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none
    ...    Post-Conditions: none
    Delete Retry operation
    Check HTTP Response Status Code Is    405
*** Keywords ***
Check resource existence
    Set Headers    {"Accept":"${ACCEPT}"} 
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_lcm_op_occs/${vnfLcmOpOccId}
    Integer    response status    200