*** Settings ***
Resource    environment/variables.txt 
Resource    VNFLCMCoordinationKeywords.robot 
Library    String
Library    REST    ${EM-VNF_SCHEMA}://${EM-VNF_HOST}:${EM-VNF_PORT}    ssl_verify=false
Library    JSONLibrary
Library    JSONSchemaLibrary    schemas/
Library    OperatingSystem
Library    DependencyLibrary

*** Test Cases ***

POST Coordination of LCM Operation Occurance and API Producer has Chosen the Synchronous Mode
    [Documentation]    Test ID: 6.3.6.2.1
    ...    Test title: Post Coordination of an LCM operation occurrence
    ...    Test Objective: The objective is to test the creation of new Individual Coordination Action, and perform a JSON schema validation of the returned LCM coordination data structure.
    ...    pre-condition: LCM operation occurrence resource is in Processing state
    ...    Reference: Clause 10.4.2.3.1 - ETSI GS NFV-SOL 002 [2] v3.6.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: API producer has chosen the synchronous mode   
    ...    Post-Condition: none
    Post coordination of LCM operation Occurance and API Producer has Chosen Synchronous Mode
    Check HTTP Response Status Code Is    201
    Check HTTP Response Body Json Schema Is    LcmCoord
    Check HTTP Response Header Contains    Location
    Check Postcondition LcmCoord Exists

POST Coordination of LCM Operation Occurance and API Producer has Chosen the Asynchronous Mode
    [Documentation]    Test ID: 6.3.6.2.2
    ...    Test title: Post Coordination of an LCM operation occurrence
    ...    Test Objective: The objective is to test that the coordination of a LCM operation occurance request has been accepted for processing, and perform a JSON schema validation of the returned LCM coordination data structure.
    ...    pre-condition: LCM operation occurrence resource is in Processing state
    ...    Reference: Clause 10.4.2.3.1 - ETSI GS NFV-SOL 002 [2] v3.6.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: API producer has chosen the asynchronous mode   
    ...    Post-Condition: none
    Post coordination of LCM operation Occurance and API Producer has Chosen Asynchronous Mode
    Check HTTP Response Status Code Is    202
    Check HTTP Response Body Should be Empty
    Check HTTP Response Header Contains    Location

POST Coordination of a LCM Operation Occurance Forbidden
    [Documentation]    Test ID: 6.3.6.2.3
    ...    Test title: Post Coordination of an LCM operation occurrence Forbidden
    ...    Test Objective: The objective is to test the failure of a request for the coordination of an LCM operation occurrence
    ...    pre-condition: The status of the related LCM opeation occurrence is "PROCESSING". The request is performed by a user that has not the grant to run this operation
    ...    Reference: Clause 10.4.2.3.1 - ETSI GS NFV-SOL 002 [2] v3.6.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none  
    ...    Post-Condition: none
    Post coordination of LCM operation Occurance is Forbidden
    Check HTTP Response Status Code Is    403
    Check HTTP Response Body Json Schema Is    ProblemDetails 

POST Coordination of LCM Operation Occurance Conflict
    [Documentation]    Test ID: 6.3.6.2.4
    ...    Test title: Post Coordination of an LCM operation occurrence Conflict
    ...    Test Objective: The objective is to verify that no coordination actions can be executed currently, due to a conflict with the state of the "Coordinations" resource.
    ...    pre-condition: The status of the related LCM opeation occurrence is not "PROCESSING"
    ...    Reference: Clause 10.4.2.3.1 - ETSI GS NFV-SOL 002 [2] v3.6.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: When there are many coordination actions exist, or conflicting ones, are in progress.
    ...    Post-Condition: none
    Post coordination of LCM operation Occurance - conflict
    Check HTTP Response Status Code Is    409
    Check HTTP Response Body Json Schema Is    ProblemDetails 

POST Coordination of LCM Operation Occurance Service Unavailable 
    [Documentation]    Test ID: 6.3.6.2.5
    ...    Test title: Post Coordination of an LCM operation occurrence Service Unavailable 
    ...    Test Objective: The objective is to test the request for the coordination of an LCM operation occurrence and the verify that the NFVO cannot perform immediately the request, but can perform it sometime in the future. 
    ...    pre-condition: The status of the related LCM opeation occurrence is "PROCESSING" but API producer cannot perform immediately the request
    ...    Reference: Clause 10.4.2.3.1 - ETSI GS NFV-SOL 002 [2] v3.6.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: API producer has chosen the synchronous mode
    ...    Post-Condition: none
    Post coordination of LCM operation Occurance and API Producer has Chosen Synchronous Mode - Service Unavailable
    Check HTTP Response Status Code Is    503
    Check HTTP Response Header Contains    Retry-After
    Check HTTP Response Body Json Schema Is    ProblemDetails

POST Coordination of an LCM operation occurrence without authentication
    [Documentation]    Test ID: 6.3.6.2.6
    ...    Test title:  Request a Coordination of an LCM operation occurrence without authentication
    ...    Test objective: The objective is to test the failure of the request for the coordination of an LCM operation occurrence without providing an authentication token
    ...    Pre-conditions: The status of the related LCM opeation occurrence is "PROCESSING"
    ...    Reference: Clause 10.4.2.3.1 - ETSI GS NFV-SOL 002 [2] v3.6.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none
    ...    Post-Conditions: none
    Post Request for coordination of an LCM operation occurrence without authorization token
    Check HTTP Response Status Code Is    401

GET Coordination of a LCM Operation Occurance - Method not implemented
    [Documentation]    Test ID: 6.3.6.2.7
    ...    Test title: GET Coordination of a LCM Operation Occurance - Method not implemented
    ...    Test Objective: The objective is to test that GET method for Resource Coordinations is not implemented.
    ...    pre-condition: none
    ...    Reference: Clause 10.4.2.3.2 - ETSI GS NFV-SOL 002 [2] v3.6.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none  
    ...    Post-Condition: none
    GET coordination of LCM operation Occurance
    Check HTTP Response Status Code Is    405

PUT Coordination of a LCM Operation Occurance - Method not implemented
    [Documentation]    Test ID: 6.3.6.2.8
    ...    Test title: PUT Coordination of a LCM Operation Occurance - Method not implemented
    ...    Test Objective: The objective is to test that PUT method for Resource Coordinations is not implemented.
    ...    pre-condition: none
    ...    Reference: Clause 10.4.2.3.3 - ETSI GS NFV-SOL 002 [2] v3.6.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none  
    ...    Post-Condition: none
    PUT coordination of LCM operation Occurance
    Check HTTP Response Status Code Is    405

PACTH Coordination of a LCM Operation Occurance - Method not implemented
    [Documentation]    Test ID: 6.3.6.2.9
    ...    Test title: PATCH Coordination of a LCM Operation Occurance - Method not implemented
    ...    Test Objective: The objective is to test that PATCH method for Resource Coordinations is not implemented.
    ...    pre-condition: none
    ...    Reference: Clause 10.4.2.3.4 - ETSI GS NFV-SOL 002 [2] v3.6.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none  
    ...    Post-Condition: none
    PATCH coordination of LCM operation Occurance
    Check HTTP Response Status Code Is    405

DELETE Coordination of a LCM Operation Occurance - Method not implemented
    [Documentation]    Test ID: 6.3.6.2.10
    ...    Test title: DELETE Coordination of a LCM Operation Occurance - Method not implemented
    ...    Test Objective: The objective is to test that DELETE method for Resource Coordinations is not implemented.
    ...    pre-condition: none
    ...    Reference: Clause 10.4.2.3.5 - ETSI GS NFV-SOL 002 [2] v3.6.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none  
    ...    Post-Condition: none
    DELETE coordination of LCM operation Occurance
    Check HTTP Response Status Code Is    405