*** Settings ***
Resource   environment/variables.txt 
Library    REST    ${NFVO_SCHEMA}://${NFVO_HOST}:${NFVO_PORT}    ssl_verify=false
Library    OperatingSystem
Library    JSONLibrary
Library    JSONSchemaLibrary    schemas/

*** Test Cases ***
Requests a grant for a particular NS lifecycle operation
    [Documentation]    Test ID: 9.3.3.1.1
    ...    Test title: Requests a grant for a particular NS lifecycle operation
    ...    Test objective: The objective is to request a grant for a particular NS lifecycle operation and perform a JSON schema validation on the returned grant data structure
    ...    Pre-conditions: 
    ...    Reference: Clause 7.5.3.3.1 - ETSI GS NFV-SOL 011 [6] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: The NFVO can decide immediately what to respond to a grant request
    ...    Post-Conditions: The grant information is available to the NFVO.
    Send Post Request for Grant
    Check HTTP Response Status Code Is    201
    Check HTTP Response Body Json Schema Is    Grant
    Check HTTP Response Header Contains  Location 
    Check Resource URI existence  

Requests a grant for a particular NS lifecycle operation - Forbidden 
    [Documentation]    Test ID: 9.3.3.1.2
    ...    Test title: Requests a grant for a particular NS lifecycle operation - Forbidden 
    ...    Test objective: The objective is to request a grant for a particular NS lifecycle operation and the grant is rejected
    ...    Pre-conditions: none
    ...    Reference: Clause 7.5.3.3.1 - ETSI GS NFV-SOL 011 [6] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send Request for a new Grant Forbiden Operation
    Check HTTP Response Status Code Is    403
    Check HTTP Response Body Json Schema Is    ProblemDetails
    
GET Grants - Method not implemented
    [Documentation]    Test ID: 9.3.3.1.3
    ...    Test title: GET Grants - Method not implemented
    ...    Test objective: The objective is to test that GET method is not allowed for Life cycle operation granting 
    ...    Pre-conditions: none
    ...    Reference: Clause 7.5.3.3.2 - ETSI GS NFV-SOL 011 [6] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions:   none
    Get Grants
    Check HTTP Response Status Code Is    405
    
PUT Grants - Method not implemented
     [Documentation]    Test ID: 9.3.3.1.4
    ...    Test title: PUT Grants - Method not implemented
    ...    Test objective: The objective is to test that PUT method is not allowed for Life cycle operation granting 
    ...    Pre-conditions: none
    ...    Reference: Clause 7.5.3.3.3 - ETSI GS NFV-SOL 011 [6] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Put Grants
    Check HTTP Response Status Code Is    405
    
PATCH Grants - Method not implemented
    [Documentation]    Test ID: 9.3.3.1.5
    ...    Test title: PATCH Grants - Method not implemented
    ...    Test objective: The objective is to test that PATCH method is not allowed for Life cycle operation granting  
    ...    Pre-conditions: none
    ...    Reference: Clause 7.5.3.3.4 - ETSI GS NFV-SOL 011 [6] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none 
    Patch Grants
    Check HTTP Response Status Code Is    405
    
DELETE Grants - Method not implemented
    [Documentation]    Test ID: 9.3.3.1.6
    ...    Test title: DELETE Grants - Method not implemented
    ...    Test objective: The objective is to test that DELETE method is not allowed for Life cycle operation granting  
    ...    Pre-conditions: none
    ...    Reference: Clause 7.5.3.3.5 - ETSI GS NFV-SOL 011 [6] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions:  resources are not deleted
    Delete Grants
    Check HTTP Response Status Code Is    405
    Get an individual grant - Successful

*** Keywords ***
Send Post Request for Grant
    Log    Request a new Grant for an NS LCM operation by POST to ${apiRoot}/${apiName}/${apiVersion}/grants
    Set Headers    {"Accept": "${ACCEPT}"}
    Set Headers    {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    ${body}=    Get File    jsons/grantNSLifecycleOperationRequest.json
    Post    ${apiRoot}/${apiName}/${apiVersion}/grants    ${body}
    ${body}=    Output    response
    Set Suite Variable    ${response}    ${body}
        
Send Request for a new Grant Forbiden Operation   
    Log    Request a new Grant for a NS LCM operation by POST to ${apiRoot}/${apiName}/${apiVersion}/grants
    Log    The grant request should be rejected
    Set Headers    {"Accept": "${ACCEPT}"}
    Set Headers    {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    ${body}=    Get File    jsons/grantRejected.json
    Post    ${apiRoot}/${apiName}/${apiVersion}/grants    ${body}
    ${body}=    Output    response
    Set Suite Variable    ${response}    ${body}
    
Check HTTP Response Status Code Is
    [Arguments]    ${expected_status}    
    Should Be Equal As Strings    ${response['status']}    ${expected_status}
    Log    Status code validated

Check HTTP Response Header Contains
    [Arguments]    ${CONTENT_TYPE}
    Should Contain    ${response['headers']}    ${CONTENT_TYPE}
    Log    Header is present
    
Check Resource URI existence 
    ${uri}=    Get Value From Json    ${response['headers']}    $..Location
    Should Not Be Empty    ${uri}
    
Check HTTP Response Body Json Schema Is
    [Arguments]    ${input}
    ${schema} =    Catenate    ${input}    .schema.json
    Validate Json    ${schema}    ${response['body']}
    
Get Grants
    Log    Trying to perform a GET. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"} 
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    Get    ${apiRoot}/${apiName}/${apiVersion}/grants
    ${body}=    Output    response
    Set Suite Variable    ${response}    ${body}
    
Put Grants
    Log    Trying to perform a PUT. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"} 
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    Put    ${apiRoot}/${apiName}/${apiVersion}/grants
    ${body}=    Output    response
    Set Suite Variable    ${response}    ${body}
    
Patch Grants
    Log    Trying to perform a PATCH. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"} 
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    Patch    ${apiRoot}/${apiName}/${apiVersion}/grants
    ${body}=    Output    response
    Set Suite Variable    ${response}    ${body}
    
    
Delete Grants
    Log    Trying to perform a DELETE. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"} 
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    Delete    ${apiRoot}/${apiName}/${apiVersion}/grants
    ${body}=    Output    response
    Set Suite Variable    ${response}    ${body}

Get an individual grant - Successful
    log    Trying to read an individual grant
    Set Headers    {"Accept":"${ACCEPT}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    Get    ${response['headers']['Location']}
    Log    Validate Status code
    Integer    response status    200