*** Settings ***
Resource   environment/variables.txt 
Library    REST    ${NFVO_SCHEMA}://${NFVO_HOST}:${NFVO_PORT}    ssl_verify=false
Library    OperatingSystem
Library    JSONLibrary
Library    JSONSchemaLibrary    schemas/

*** Test Cases ***
POST Create a new subscription
    [Documentation]    Test ID: 9.3.4.1.1
    ...    Test title: POST Create a new subscription
    ...    Test objective: The objective is to test that POST method creates a subscription
    ...    Pre-conditions: none
    ...    Reference: Clause 8.5.3.3.1 - ETSI GS NFV-SOL 011 [6] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: Subscription is created in the NFVO     
    POST subscriptions
    Check HTTP Response Status Code Is    201
    Check HTTP Response Header Contains    Location
    Check HTTP Response Body Json Schema Is    subscription
    Check Resource URI

POST Create a new Subscription - DUPLICATION
    [Documentation]    Test ID: 9.3.4.1.2
    ...    Test title: POST Create a new subscription - DUPLICATION
    ...    Test objective: The objective is to test that POST method creates a duplicate subscription 
    ...    Pre-conditions: A subscription shall already exist 
    ...    Reference: Clause 8.5.3.3.1 - ETSI GS NFV-SOL 011 [6] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: Duplication supported by NFVO-C
    ...    Post-Conditions: Duplicate subscription is created in the NFVO     
    Check Subscription Existence
    POST subscriptions DUPLICATION
    Check HTTP Response Status Code Is    201
    Check HTTP Response Header Contains    Location
    Check HTTP Response Body Json Schema Is    subscription 
    
POST Create a new Subscription - NO-DUPLICATION
    [Documentation]    Test ID: 9.3.4.1.3
    ...    Test title: POST Create a new subscription - NO-DUPLICATION
    ...    Test objective: The objective is to test that POST method cannot create a duplicate subscription 
    ...    Pre-conditions: A subscription shall already exist
    ...    Reference: Clause 8.5.3.3.1 - ETSI GS NFV-SOL 011 [6] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: Duplication NOT supported by NFVO-C
    ...    Post-Conditions: Duplicate subscription is not created in the NFVO     
    Check Subscription Existence
    POST subscriptions NO DUPLICATION
    Check HTTP Response Status Code Is    303
    Check HTTP Response Header Contains    Location
    
GET Subscriptions
    [Documentation]    Test ID: 9.3.4.1.4
    ...    Test title: GET Subscriptions
    ...    Test objective: The objective is to test that GET method retrieves the list of existing subscriptions
    ...    Pre-conditions: none
    ...    Reference: Clause 8.5.3.3.2 - ETSI GS NFV-SOL 011 [6] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none    
    GET Subscriptions
    Check HTTP Response Status Code Is  200
    Check HTTP Response Body Json Schema Is  subscriptions

GET Subscription - Filter
    [Documentation]    Test ID: 9.3.4.1.5
    ...    Test title: GET Subscription - Filter
    ...    Test objective: The objective is GET the list of active subscriptions using a filter
    ...    Pre-conditions: none
    ...    Reference: Clause 8.5.3.3.2 - ETSI GS NFV-SOL 011 [6] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none    
    GET Subscriptions with filter
    Check HTTP Response Status Code Is  200
    Check HTTP Response Body Json Schema Is  subscriptions
    
GET subscriptions - Bad Request Invalid attribute-based filtering parameters
    [Documentation]    Test ID: 9.3.4.1.6
    ...    Test title: GET subscriptions - Bad Request Invalid attribute-based filtering parameters
    ...    Test objective: The objective is GET the list of active subscriptions using an invalid filter
    ...    Pre-conditions: none
    ...    Reference: Clause 8.5.3.3.2 - ETSI GS NFV-SOL 011 [6] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none 
    Get subscriptions - invalid filter
    Check HTTP Response Status Code Is    400
    Check HTTP Response Body Json Schema Is    ProblemDetails

GET subscriptions - Bad Request Response too Big
    [Documentation]    Test ID: 9.3.4.1.7
    ...    Test title: GET subscriptions - Bad Request Response too Big
    ...    Test objective: The objective is test that the retrieval of active subscriptions list fails because response is too big, and perform the JSON schema validation of the failed operation HTTP response.
    ...    Pre-conditions: none
    ...    Reference: Clause 8.5.3.3.2 - ETSI GS NFV-SOL 011 [6] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none 
    GET Subscriptions
    Check HTTP Response Status Code Is    400
    Check HTTP Response Body Json Schema Is    ProblemDetails
    
GET subscriptions with "all_fields" attribute selector
    [Documentation]    Test ID: 9.3.4.1.8
    ...    Test title: GET subscriptions with "all_fields" attribute selector
    ...    Test objective: The objective is to retrieve the list of active subscriptions with "all_fields" attribute selector
    ...    Pre-conditions: 
    ...    Reference: Clause 8.5.3.3.2 - ETSI GS NFV-SOL 011 [6] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability:  
    ...    Post-Conditions: 
    Get subscriptions with all_fields attribute selector
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is   subscriptions 

GET subscriptions with "exclude_default" attribute selector
    [Documentation]    Test ID: 9.3.4.1.9
    ...    Test title: GET subscriptions with "exclude_default" attribute selector
    ...    Test objective: The objective is to retrieve the list of active subscriptions with "exclude_default"s attribute selector
    ...    Pre-conditions: 
    ...    Reference: Clause 8.5.3.3.2 - ETSI GS NFV-SOL 011 [6] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability:  
    ...    Post-Conditions: 
    Get subscriptions with exclude_default attribute selector
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is   subscriptions

GET subscriptions with "fields" attribute selector
    [Documentation]    Test ID: 9.3.4.1.10
    ...    Test title: GET subscriptions with "fields" attribute selector
    ...    Test objective: The objective is to retrieve the list of active subscriptions with "fields" attribute selector
    ...    Pre-conditions: 
    ...    Reference: Clause 8.5.3.3.2 - ETSI GS NFV-SOL 011 [6] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability:  
    ...    Post-Conditions: 
    Get subscriptions with fields attribute selector
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is   subscriptions

GET subscriptions with "exclude_fields" attribute selector
    [Documentation]    Test ID: 9.3.4.1.11
    ...    Test title: GET subscriptions with "exclude_fields" attribute selector
    ...    Test objective: The objective is to retrieve the list of active subscriptions with "exclude_fields" attribute selector
    ...    Pre-conditions: 
    ...    Reference: Clause 8.5.3.3.2 - ETSI GS NFV-SOL 011 [6] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability:  
    ...    Post-Conditions: 
    Get subscriptions with exclude_fields attribute selector
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is   subscriptions  
        
GET Subscriptions as Paged Response
    [Documentation]    Test ID: 9.3.4.1.12
    ...    Test title: GET Subscriptions as Paged Response
    ...    Test objective: The objective is to test that GET method  retrieve the list of existing subscriptions as paged response.
    ...    Pre-conditions: none
    ...    Reference: Clause 8.5.3.3.2 - ETSI GS NFV-SOL 011 [6] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none    
    GET Subscriptions
    Check HTTP Response Status Code Is  200
    Check LINK in Header
        
PUT subscriptions - Method not implemented
     [Documentation]    Test ID: 9.3.4.1.13
    ...    Test title: PUT subscriptions - Method not implemented
    ...    Test objective: The objective is to test that PUT method cannot modify a NS instance usage subscription
    ...    Pre-conditions: none
    ...    Reference: Clause 8.5.3.3.3 - ETSI GS NFV-SOL 011 [6] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    PUT subscriptions
    Check HTTP Response Status Code Is    405

PATCH subscriptions - Method not implemented
    [Documentation]    Test ID: 9.3.4.1.14
    ...    Test title: PATCH subscriptions - Method not implemented
    ...    Test objective: The objective is to test that PUT method cannot modify a NS instance usage subscription
    ...    Pre-conditions: none
    ...    Reference: Clause 8.5.3.3.4 - ETSI GS NFV-SOL 011 [6] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    PATCH subscriptions
    Check HTTP Response Status Code Is    405

DELETE subscriptions - Method not implemented
    [Documentation]    Test ID: 9.3.4.1.15
    ...    Test title: DELETE subscriptions - Method not implemented
    ...    Test objective: The objective is to test that DELETE method cannot delete a NS instance usage subscription
    ...    Pre-conditions: none
    ...    Reference: Clause 8.5.3.3.5 - ETSI GS NFV-SOL 011 [6] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: Subscription is not deleted
    DELETE subscriptions
    Check HTTP Response Status Code Is    405

*** Keywords ***
Check HTTP Response Status Code Is
    [Arguments]    ${expected_status}    
    Should Be Equal As Strings    ${response['status']}    ${expected_status}
    Log    Status code validated

Check HTTP Response Header Contains
    [Arguments]    ${CONTENT_TYPE}
    Should Contain    ${response['headers']}    ${CONTENT_TYPE}
    Log    Header is present
    
Check Resource URI
    ${uri}=    Get Value From Json    ${response['headers']}    $..Location
    Should Not Be Empty    ${uri}
    Log    URI is present

Check subscription existence
    Set Headers    {"Accept":"${ACCEPT}"}  
    Set Headers    {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    Get    ${apiRoot}/${apiName}/${apiVersion}/subscriptions/${subscriptionId} 
    Integer    response status    200
    #more robust functionaity needed

#Check URI is Of Existing Resource
#    ${uri}=    Get Value From Json    ${response['headers']}    $..Location
#    Should Be Equal As Strings    ${uri}    ${}
    
Check LINK in Header
    ${linkURL}=    Get Value From Json    ${response['headers']}    $..Link
    Should Not Be Empty    ${linkURL}

Check HTTP Response Body Json Schema Is
    [Arguments]    ${input}
    ${schema} =    Catenate    ${input}    .schema.json
    Validate Json    ${schema}    ${response['body']}

POST subscriptions
    Log    Create subscription instance by POST to ${apiRoot}/${apiName}/${apiVersion}/subscriptions
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    ${body}=    Get File    jsons/NsInstanceUsageSubscriptionRequest.json
    Post    ${apiRoot}/${apiName}/${apiVersion}/subscriptions    ${body}    
	${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
POST subscriptions DUPLICATION
    Log    Trying to create a subscription with an already created content
    Pass Execution If    ${NFVO_DUPLICATION} == 1    NFVO is permitting duplication. Skipping the test
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    ${body}=    Get File    jsons/NsInstanceUsageSubscriptionRequest.json
    Post    ${apiRoot}/${apiName}/${apiVersion}/subscriptions    ${body}    
	${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
POST subscriptions NO DUPLICATION
    Log    Trying to create a subscription with an already created content
    Pass Execution If    ${NFVO_DUPLICATION} == 0    NFVO is not permitting duplication.
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    ${body}=    Get File    jsons/NsInstanceUsageSubscriptionRequest.json
    Post    ${apiRoot}/${apiName}/${apiVersion}/subscriptions    ${body}    
	${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
GET Subscriptions
    Log    Get the list of active subscriptions
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    Log    Execute Query and validate response
    Get    ${apiRoot}/${apiName}/${apiVersion}/subscriptions
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}

Get subscriptions with all_fields attribute selector
    Log    Get the list of active subscriptions, using fields
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiVersion}/subscriptions?all_fields
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
Get subscriptions with exclude_default attribute selector
    Log    Get the list of active subscriptions, using fields
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiVersion}/subscriptions?exclude_default
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
Get subscriptions with fields attribute selector
    Log    Get the list of active subscriptions, using fields
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiVersion}/subscriptions?fields=${fields}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}	
    
Get subscriptions with exclude_fields attribute selector
    Log    Get the list of active subscriptions, using fields
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiVersion}/subscriptions?exclude_fields=${fields}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}     
	
GET subscriptions with filter  
    Log    Get the list of active subscriptions using a filter
    Set Headers    {"Accept": "${ACCEPT}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiVersion}/subscriptions?${sub_filter}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}

Get subscriptions - invalid filter
    Log    Get the list of active subscriptions using an invalid filter
    Set Headers    {"Accept": "${ACCEPT}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiVersion}/subscriptions?${sub_filter_invalid} 
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
PUT subscriptions
    Log    Trying to perform a PUT. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    Put    ${apiRoot}/${apiName}/${apiVersion}/subscriptions    
	${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
PATCH subscriptions
    Log    Trying to perform a PATCH. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    Patch    ${apiRoot}/${apiName}/${apiVersion}/subscriptions    
	${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
DELETE subscriptions
    Log    Trying to perform a DELETE. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    Delete    ${apiRoot}/${apiName}/${apiVersion}/subscriptions    
	${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}