*** Settings ***
Resource    environment/variables.txt
Library    REST    ${NFVMANO_SCHEMA}://${NFVMANO_HOST}:${NFVMANO_PORT}    ssl_verify=false
Library    MockServerLibrary 
Library    OperatingSystem
Library    BuiltIn
Library    JSONLibrary
Library    Collections
Library    JSONSchemaLibrary    schemas/
Library    Process

*** Keywords ***
Check HTTP Response Status Code Is
    [Arguments]    ${expected_status}
    ${status}=    Convert To Integer    ${expected_status}    
    Should Be Equal    ${response['status']}    ${status} 
    Log    Status code validated

Check HTTP Response Header Contains
    [Arguments]    ${CONTENT_TYPE}
    Should Contain    ${response['headers']}    ${CONTENT_TYPE}
    Log    Header is present
    
Check HTTP Response Body Json Schema Is
    [Arguments]    ${input}
    Should Contain    ${response['headers']['Content-Type']}    application/json
    ${schema} =    Catenate    SEPARATOR=    ${input}    .schema.json
    Validate Json    ${schema}    ${response['body']}
    Log    Json Schema Validation OK
    
Check Operation Occurrence Id
    ${OpOccId}=    Get Value From Json    ${response['headers']}    $..Location
    Should Not Be Empty    ${OpOccId}

Send Post request for NFV-MANO Entity
    Log    Trying to perform a POST (method should not be implemented)
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    POST    ${apiRoot}/${apiName}/${apiMajorVersion}/mano_entity
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
GET NFV-MANO entity resource
    Log    Trying to get a NFV-MANO entity resource 
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/mano_entity
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Send Put request for NFV-MANO Entity  
    Log    Trying to perform a PUT (method should not be implemented)
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/log_jobs/mano_entity
    ${origOutput}=    Output    response
    Set Suite Variable    ${origResponse}    ${origOutput}
    PUT    ${apiRoot}/${apiName}/${apiMajorVersion}/log_jobs/mano_entity
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Send Patch request for NFV-MANO Entity
    log    Trying to modify an NFV-MANO Entity
    Set Headers    {"Accept":"${ACCEPT_JSON}"}  
    Set Headers    {"Content-Type": "${CONTENT_TYPE_PATCH}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    ${body}=    Get File    jsons/ManoConfigModificationRequest.json
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/mano_entity   ${body}	
    ${outputResponse}=    Output    response
	Set Global Variable    @{response}    ${outputResponse} 
	
Send Delete request for NFV-MANO Entity
    Log    Trying to perform a DELETE (method should not be implemented)
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    DELETE    ${apiRoot}/${apiName}/${apiMajorVersion}/mano_entity
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
Send Post request for NFV-MANO functional entity application state change
    Log    Trying to perform a POST for NFV-MANO functional entity application state change
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    POST    ${apiRoot}/${apiName}/${apiMajorVersion}/mano_entity/change_state
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
Send Get request for NFV-MANO functional entity application state change
    Log    Trying to perform a GET (method should not be implemented)
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/mano_entity/change_state
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
Send Put request for NFV-MANO functional entity application state change
    Log    Trying to perform a PUT (method should not be implemented)
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/log_jobs/mano_entity/change_state
    ${origOutput}=    Output    response
    Set Suite Variable    ${origResponse}    ${origOutput}
    PUT    ${apiRoot}/${apiName}/${apiMajorVersion}/log_jobs/mano_entity/change_state
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
Send Patch request for NFV-MANO functional entity application state change
    Log    Trying to perform a PATCH (method should not be implemented)
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    PATCH    ${apiRoot}/${apiName}/${apiMajorVersion}/mano_entity/change_state
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Send Delete request for NFV-MANO functional entity application state change
    Log    Trying to perform a DELETE (method should not be implemented)
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    DELETE    ${apiRoot}/${apiName}/${apiMajorVersion}/mano_entity/change_state
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
Send Post request for Change State Operation Occurance
    Log    Trying to perform a POST (method should not be implemented)
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    POST    ${apiRoot}/${apiName}/${apiMajorVersion}/change_state_ops
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
Get Change State OpOcc
    Log    Query to GET information about multiple change state operation occurrences.
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    Log    Execute Query and validate response
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/change_state_ops
    ${outputResponse}=    Output    response
	Set Global Variable    @{response}    ${outputResponse}
	
Get Change State OpOcc with invalid filter
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    Log    Execute Query and validate response
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/change_state_ops?attribute_not_exist=some_value
    ${outputResponse}=    Output    response
	Set Global Variable    @{response}    ${outputResponse}	
	
Get Change State OpOcc with invalid selector
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    Log    Execute Query and validate response
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/change_state_ops?fields=wrong_field
    ${outputResponse}=    Output    response
	Set Global Variable    @{response}    ${outputResponse}	

Get Change State OpOcc with filter
    Log    Query  information about multiple change state operation occurrences with attribute filters.
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    Log    Execute Query and validate response
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/change_state_ops?${filter}=${filter_value} 
    ${outputResponse}=    Output    response
	Set Global Variable    @{response}    ${outputResponse}
	
Get Change State OpOcc with all_fields attribute selector
    Log    Queries information about multiple change state operation occurrences, using all_fields
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/change_state_ops?exclude_default
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Get Change State OpOcc with fields attribute selector
    Log    Queries information about multiple change state operation occurrences, using fields
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/change_state_ops?fields=${fields}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Get Change State OpOcc with exclude_fields attribute selector
    Log    Queries information about multiple change state operation occurrences, using fields
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/change_state_ops?exclude_fields=${fields}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
Check LINK in Header
    ${linkURL}=    Get Value From Json    ${response['headers']}    $..Link
    Should Not Be Empty    ${linkURL}

Send PUT request for Change State Operation Occurance
    log    Trying to perform a PUT. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/change_state_ops
    ${outputResponse}=    Output    response
	Set Global Variable    @{response}    ${outputResponse}
	
Send PATCH request for Change State Operation Occurance
    log    Trying to perform a PATCH. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/change_state_ops
    ${outputResponse}=    Output    response
	Set Global Variable    @{response}    ${outputResponse}
	
Send DELETE request for Change State Operation Occurance
    log    Trying to perform a DELETE. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    Delete    ${apiRoot}/${apiName}/${apiMajorVersion}/change_state_ops
    ${outputResponse}=    Output    response
	Set Global Variable    @{response}    ${outputResponse}
	
Send Post request for Individual Change State Operation Occurance
    Log    Trying to perform a POST (method should not be implemented)
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    POST    ${apiRoot}/${apiName}/${apiMajorVersion}/change_state_ops/${changeStateOpOccId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
Get Individual Change State OpOcc
    Log    Query to GET information about individual change state operation occurrences.
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    Log    Execute Query and validate response
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/change_state_ops/${changeStateOpOccId}
    ${outputResponse}=    Output    response
	Set Global Variable    @{response}    ${outputResponse}
	
Send PUT request for Individual Change State Operation Occurance
    log    Trying to perform a PUT. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/change_state_ops/${changeStateOpOccId}
    ${outputResponse}=    Output    response
	Set Global Variable    @{response}    ${outputResponse}
	
Send PATCH request for Individual Change State Operation Occurance
    log    Trying to perform a PATCH. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/change_state_ops/${changeStateOpOccId}
    ${outputResponse}=    Output    response
	Set Global Variable    @{response}    ${outputResponse}
	
Send DELETE request for Individual Change State Operation Occurance
    log    Trying to perform a DELETE. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    Delete    ${apiRoot}/${apiName}/${apiMajorVersion}/change_state_ops/${changeStateOpOccId}
    ${outputResponse}=    Output    response
	Set Global Variable    @{response}    ${outputResponse}
	
Send Post request for NFV-MANO Serive Interface
    Log    Trying to perform a POST (method should not be implemented)
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    POST    ${apiRoot}/${apiName}/${apiMajorVersion}/mano_entity/mano_interfaces
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
Get NFV-MANO Serive Interface
    Log    Query to GET information about multiple NFV-MANO service interfaces of the NFV-MANO functional entity.
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    Log    Execute Query and validate response
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/mano_entity/mano_interfaces
    ${outputResponse}=    Output    response
	Set Global Variable    @{response}    ${outputResponse}
	
Get NFV-MANO Serive Interface with invalid filter
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    Log    Execute Query and validate response
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/mano_entity/mano_interfaces?attribute_not_exist=some_value
    ${outputResponse}=    Output    response
	Set Global Variable    @{response}    ${outputResponse}	
	
Get NFV-MANO Serive Interface with invalid selector
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    Log    Execute Query and validate response
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/mano_entity/mano_interfaces?fields=wrong_field
    ${outputResponse}=    Output    response
	Set Global Variable    @{response}    ${outputResponse}	

Get NFV-MANO Serive Interface with filter
    Log    Query  information about multiple NFV-MANO service interfaces of the NFV-MANO functional entity with attribute filters.
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    Log    Execute Query and validate response
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/mano_entity/mano_interfaces?${filter}=${filter_value} 
    ${outputResponse}=    Output    response
	Set Global Variable    @{response}    ${outputResponse}
	
Get NFV-MANO Serive Interface with all_fields attribute selector
    Log    Queries information about multiple NFV-MANO service interfaces of the NFV-MANO functional entity, using all_fields
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/mano_entity/mano_interfaces?exclude_default
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Get NFV-MANO Serive Interface with fields attribute selector
    Log    Queries information about multiple NFV-MANO service interfaces of the NFV-MANO functional entity, using fields
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/mano_entity/mano_interfaces?fields=${fields}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Get NFV-MANO Serive Interface with exclude_fields attribute selector
    Log    Queries information about multiple NFV-MANO service interfaces of the NFV-MANO functional entity, using fields
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/mano_entity/mano_interfaces?exclude_fields=${fields}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
Send PUT request for NFV-MANO Serive Interface
    log    Trying to perform a PUT. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/mano_entity/mano_interfaces
    ${outputResponse}=    Output    response
	Set Global Variable    @{response}    ${outputResponse}
	
Send PATCH request for NFV-MANO Serive Interface
    log    Trying to perform a PATCH. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/mano_entity/mano_interfaces
    ${outputResponse}=    Output    response
	Set Global Variable    @{response}    ${outputResponse}
	
Send DELETE request for NFV-MANO Serive Interface
    log    Trying to perform a DELETE. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    Delete    ${apiRoot}/${apiName}/${apiMajorVersion}/mano_entity/mano_interfaces
    ${outputResponse}=    Output    response
	Set Global Variable    @{response}    ${outputResponse}
	
Send Post request for Individual NFV-MANO Serive Interface
    Log    Trying to perform a POST (method should not be implemented)
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    POST    ${apiRoot}/${apiName}/${apiMajorVersion}/mano_entity/mano_interfaces/${manoServiceInterfaceId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
Get Individual NFV-MANO Serive Interface
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    Log    Execute Query and validate response
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/mano_entity/mano_interfaces/${manoServiceInterfaceId}
    ${outputResponse}=    Output    response
	Set Global Variable    @{response}    ${outputResponse}
	
Send Put request for Individual NFV-MANO Serive Interface
    log    Trying to perform a PUT. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/mano_entity/mano_interfaces/${manoServiceInterfaceId}
    ${outputResponse}=    Output    response
	Set Global Variable    @{response}    ${outputResponse}
	
Send Patch request for Individual NFV-MANO Serive Interface
    log    Trying to modify an NFV-MANO Entity
    Set Headers    {"Accept":"${ACCEPT_JSON}"}  
    Set Headers    {"Content-Type": "${CONTENT_TYPE_PATCH}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    ${body}=    Get File    jsons/ManoServiceInterfaceModificationRequest.json
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/mano_entity/mano_interfaces/${manoServiceInterfaceId}   ${body}	
    ${outputResponse}=    Output    response
	Set Global Variable    @{response}    ${outputResponse}
	
Send Delete request for Individual NFV-MANO Serive Interface
    log    Trying to perform a DELETE. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    Delete    ${apiRoot}/${apiName}/${apiMajorVersion}/mano_entity/mano_interfaces/${manoServiceInterfaceId}
    ${outputResponse}=    Output    response
	Set Global Variable    @{response}    ${outputResponse}
	
Send Post request for Change interface state task
    Log    Trying to perform a POST for Change interface state task
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    ${body}=    Get File    jsons/ChangeStateRequest.json
    POST    ${apiRoot}/${apiName}/${apiMajorVersion}/mano_entity/mano_interfaces/${manoServiceInterfaceId}/change_state    ${body}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
Send Get request for Change interface state task
    Log    Trying to perform a GET (method should not be implemented)
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/mano_entity/mano_interfaces/${manoServiceInterfaceId}/change_state
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
Send Put request for Change interface state task
    Log    Trying to perform a PUT (method should not be implemented)
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/mano_entity/mano_interfaces/${manoServiceInterfaceId}/change_state
    ${origOutput}=    Output    response
    Set Suite Variable    ${origResponse}    ${origOutput}
    PUT    ${apiRoot}/${apiName}/${apiMajorVersion}/mano_entity/mano_interfaces/${manoServiceInterfaceId}/change_state
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
Send Patch request for Change interface state task
    Log    Trying to perform a PATCH (method should not be implemented)
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    PATCH    ${apiRoot}/${apiName}/${apiMajorVersion}/mano_entity/mano_interfaces/${manoServiceInterfaceId}/change_state
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Send Delete request for Change interface state task
    Log    Trying to perform a DELETE (method should not be implemented)
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    DELETE    ${apiRoot}/${apiName}/${apiMajorVersion}//mano_entity/mano_interfaces/${manoServiceInterfaceId}/change_state
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
Send Post request for Peer Entity
    Log    Trying to perform a POST for Peer Entity
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    ${body}=    Get File    jsons/CreatePeerEntityRequest.json
    POST    ${apiRoot}/${apiName}/${apiMajorVersion}/peer_entities    ${body}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
Get Peer Entity
    Log    Query to GET information about multiple peer entities.
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    Log    Execute Query and validate response
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/peer_entities
    ${outputResponse}=    Output    response
	Set Global Variable    @{response}    ${outputResponse}
	
Get Peer Entity with invalid filter
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    Log    Execute Query and validate response
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/peer_entities?attribute_not_exist=some_value
    ${outputResponse}=    Output    response
	Set Global Variable    @{response}    ${outputResponse}	
	
Get Peer Entity with invalid selector
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    Log    Execute Query and validate response
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/peer_entities?fields=wrong_field
    ${outputResponse}=    Output    response
	Set Global Variable    @{response}    ${outputResponse}	

Get Peer Entity with filter
    Log    Query  information about multiple peer entities with attribute filters.
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    Log    Execute Query and validate response
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/peer_entities?${filter}=${filter_value} 
    ${outputResponse}=    Output    response
	Set Global Variable    @{response}    ${outputResponse}
	
Get Peer Entity with all_fields attribute selector
    Log    Queries information about multiple peer entities, using all_fields
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/peer_entities?exclude_default
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Get Peer Entity with fields attribute selector
    Log    Queries information about multiple peer entities, using fields
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/peer_entities?fields=${fields}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Get Peer Entity with exclude_fields attribute selector
    Log    Queries information about multiple peer entities, using fields
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/peer_entities?exclude_fields=${fields}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
Send PUT request for Peer Entity
    log    Trying to perform a PUT. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/peer_entities
    ${outputResponse}=    Output    response
	Set Global Variable    @{response}    ${outputResponse}
	
Send PATCH request for Peer Entity
    log    Trying to perform a PATCH. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/peer_entities
    ${outputResponse}=    Output    response
	Set Global Variable    @{response}    ${outputResponse}
	
Send DELETE request for Peer Entity
    log    Trying to perform a DELETE. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    Delete    ${apiRoot}/${apiName}/${apiMajorVersion}/peer_entities
    ${outputResponse}=    Output    response
	Set Global Variable    @{response}    ${outputResponse}
	
Send Post request for Individual Peer Entity
    Log    Trying to perform a POST (method should not be implemented)
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    POST    ${apiRoot}/${apiName}/${apiMajorVersion}/peer_entities/${peerEntityId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
Get Individual Peer Entity
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    Log    Execute Query and validate response
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/peer_entities/${peerEntityId}
    ${outputResponse}=    Output    response
	Set Global Variable    @{response}    ${outputResponse}
	
Send Put request for Individual Peer Entity
    log    Trying to perform a PUT. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/peer_entities/${peerEntityId}
    ${outputResponse}=    Output    response
	Set Global Variable    @{response}    ${outputResponse}
	
Send Patch request for Individual Peer Entity
    log    Trying to modify an NFV-MANO Entity
    Set Headers    {"Accept":"${ACCEPT_JSON}"}  
    Set Headers    {"Content-Type": "${CONTENT_TYPE_PATCH}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    ${body}=    Get File    jsons/PeerEntityConfigModificationRequest.json
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/peer_entities/${peerEntityId}   ${body}	
    ${outputResponse}=    Output    response
	Set Global Variable    @{response}    ${outputResponse}
	
Send Delete request for Individual Peer Entity
    log    Trying to perform a DELETE. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    Delete    ${apiRoot}/${apiName}/${apiMajorVersion}/peer_entities/${peerEntityId}
    ${outputResponse}=    Output    response
	Set Global Variable    @{response}    ${outputResponse}
	


	
Create Sessions
    Pass Execution If    ${NFVMANO_CHECKS_NOTIF_ENDPOINT} == 0   MockServer not necessary to run    
    Start Process  java  -jar  ${MOCK_SERVER_JAR}    -serverPort  ${callback_port}  alias=mockInstance
    Wait For Process  handle=mockInstance  timeout=5s  on_timeout=continue
    Create Mock Session  ${callback_uri}:${callback_port}
    
Check Notification Endpoint
    &{notification_request}=  Create Mock Request Matcher	GET  ${callback_endpoint}    
    &{notification_response}=  Create Mock Response	headers="Content-Type: application/json"  status_code=204
    Create Mock Expectation  ${notification_request}  ${notification_response}
    Wait Until Keyword Succeeds    ${total_polling_time}   ${polling_interval}   Verify Mock Expectation    ${notification_request}
    Clear Requests  ${callback_endpoint}

    
Get all Subscriptions
    [Documentation]    The api consumer can use this method to query the list of active subscriptions to log management notifications
    Set headers    {"Accept": "application/json"}
    Set headers    {"Content-Type": "application/json"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": ${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
 Get Subscriptions with attribute-based filters
    [Documentation]    The api consumer can use this method to query the list of active subscriptions to log management notifications
    Set headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": ${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions?${filter_ok}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
Get Subscriptions with invalid attribute-based filters
    [Documentation]    The api consumer can use this method to query the list of active subscriptions to log management notifications
    Set headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": ${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions?${filter_ko}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
Send Post Request for Subscription
    Set headers    {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Set headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": ${AUTHORIZATION}"}
    ${body_request}=    Get File    jsons/CimSubscriptionRequest.json
    POST    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions    ${body_request}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    Run Keyword If    ${NFVMANO_CHECKS_NOTIF_ENDPOINT} == 1
    ...       Check Notification Endpoint

Check HTTP Response Body CimSubscription Attributes Values Match the Issued Subscription
    Log    Check Response matches subscription
    ${body}=    Get File    jsons/subscriptions.json
    ${subscription}=    evaluate    json.loads('''${body}''')    json
    Should Be Equal As Strings    ${response['body']['callbackUri']}    ${subscription['callbackUri']}

Check Postcondition Subscription Is Set
    Log    Check Postcondition subscription exist
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions/${response['body']['id']}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    Check HTTP Response Status Code Is    200
    
Send Post Request for Duplicated Subscription
    Set headers    {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Set headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    ${body_request}=    Get File    jsons/CimSubscriptionRequest.json
    POST    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions    ${body_request}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}  
    
Check HTTP Response Body Is Empty
    Should Be Empty    ${response['body']}    
    Log    No json schema is provided. Validation OK  
    
Check Postcondition Subscription Resource Returned in Location Header Is Available
    Log    Going to check postcondition
    GET    ${response['headers']['Location']}
    Integer    response status    200
    Log    Received a 200 OK as expected
    ${contentType}=    Output    response headers Content-Type
    Should Contain    ${contentType}    application/json
    ${result}=    Output    response body
    Validate Json    CimSubscription.schema.json    ${result}
    Log    Validated CimSubscription schema
    ${body}=    Get File    jsons/subscriptions.json
    ${subscription}=    evaluate    json.loads('''${body}''')    json
    Should Be Equal    ${result['callbackUri']}    ${subscription['callbackUri']}
    Log    Validated Issued subscription is same as original
    
Send Put Request for Subscriptions
    [Documentation]    This method is not supported. When this method is requested on this resource, the NFV-MANO shall return a "405 Method
    ...    Not Allowed" response as defined in clause 4.3.5.4.
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    PUT    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Send Patch Request for Subscriptions
    [Documentation]    This method is not supported. When this method is requested on this resource, the NFV-MANO shall return a "405 Method
    ...    Not Allowed" response as defined in clause 4.3.5.4.
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    PATCH    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Send Delete Request for Subscriptions
    [Documentation]    This method is not supported. When this method is requested on this resource, the NFV-MANO shall return a "405 Method
    ...    Not Allowed" response as defined in clause 4.3.5.4.
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    DELETE    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
Check Postcondition Subscriptions Exists
    Log    Checking that subscriptions exists
    Get all Subscriptions
    Check HTTP Response Status Code Is    200
    
Get Individual Subscription
    Set headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions/${subscriptionId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
Check HTTP Response Body Subscription Identifier matches the requested Subscription
    Log    Trying to check response ID
    Should Be Equal As Strings    ${response['body']['id']}    ${subscriptionId} 
    Log    Subscription identifier as expected
    
GET individual Subscription with invalid resource identifier
    Set headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions/${erroneousSubscriptionId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Send Delete request for individual Subscription
    Set headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    DELETE    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions/${subscriptionId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
Check Postcondition Subscription is Deleted
    Log    Check Postcondition Subscription is deleted
    GET individual Subscription
    Check HTTP Response Status Code Is    404 

Send Delete request for individual Subscription with invalid resource identifier
    Log    Trying to delete a subscription in the VNFM with invalid id
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    DELETE    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions/${erroneousSubscriptionId}
    ${output}=    Output    response
    Set Suite Variable    @{response}    ${output}
    
Send Post request for individual Subscription
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    POST    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions/${newSubscriptionId}
    ${output}=    Output    response
    Set Suite Variable    @{response}    ${output}

Send Put request for individual Subscription
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions/${subscriptionId}
    ${origOutput}=    Output    response
    Set Suite Variable    ${origResponse}    ${origOutput}
    PUT    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions/${subscriptionId}
    ${output}=    Output    response
    Set Suite Variable    @{response}    ${output}
    
Send Patch request for individual Subscription
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions/${subscriptionId}
    ${origOutput}=    Output    response
    Set Suite Variable    ${origResponse}    ${origOutput}
    PATCH    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions/${subscriptionId}
    ${output}=    Output    response
    Set Suite Variable    @{response}    ${output}

Check Postcondition Subscription is Unmodified (Implicit)
    Log    Check postconidtion subscription not modified
    GET individual Subscription
    Log    Check Response matches original Subscription
    ${subscription}=    evaluate    json.loads('''${response['body']}''')    json
    Should Be Equal As Strings    ${origResponse['body']['id']}    ${subscription.id}
    Should Be Equal As Strings    ${origResponse['body']['callbackUri']}    ${subscription.callbackUri}

Check Postcondition Subscription is not Created
    Log    Trying to get a new subscription
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions/${newSubscriptionId}
    ${output}=    Output    response
    Set Suite Variable    @{response}    ${output}
    Check HTTP Response Status Code Is    404 