** Settings ***
Library           JSONSchemaLibrary    schemas/
Resource          environment/variables.txt
Library           JSONLibrary
Library           OperatingSystem
Resource          NFVMANOCimKeywords.robot
Library           REST    ${NFVMANO_SCHEMA}://${NFVMANO_HOST}:${NFVMANO_PORT}    ssl_verify=false
Library           MockServerLibrary

*** Test Cases ***
POST Change interface state task
    [Documentation]    Test ID: 8.3.1.7.1
    ...    Test title: POST Change interface state task
    ...    Test objective: The objective is send put request to change the state of the NFV-MANO service interface produced by the NFV-MANO functional entity
    ...    Pre-conditions: 
    ...    Reference: clause 5.5.12.3.1 - ETSI GS NFV-SOL 009 [5] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: 
    Send Post request for Change interface state task
    Check HTTP Response Status Code Is    202
    Check Operation Occurrence Id
    
POST Change interface state task - Conflict
    [Documentation]    Test ID: 8.3.1.7.2
    ...    Test title: POST Change interface state task - Conflict
    ...    Test objective: The objective is to test that request to cchange the state of the NFV-MANO service interface produced by the NFV-MANO functional entity failed due to a conflict with the state of the NFV-MANO entity resource and perform the JSON schema validation of the failed operation HTTP response.
    ...    Pre-conditions: 
    ...    Reference: clause 5.5.12.3.1 - ETSI GS NFV-SOL 009 [5] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: 
    Send Post request for Change interface state task
    Check HTTP Response Status Code Is    409
    Check HTTP Response Body Json Schema Is   ProblemDetails
    
GET Change interface state task - Conflict - Method not implemented
    [Documentation]    Test ID: 8.3.1.7.3
    ...    Test title: GET Change interface state task - Conflict - Method not implemented
    ...    Test objective: The objective is to test that GET method is not allowed to retrieve the changed state of the NFV-MANO functional entity application.
    ...    Pre-conditions: 
    ...    Reference: clause 5.5.12.3.2 - ETSI GS NFV-SOL 009 [5] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: 
    Send Get request for Change interface state task
    Check HTTP Response Status Code Is    405
    
PUT Change interface state task - Conflict - Method not implemented
    [Documentation]    Test ID: 8.3.1.7.4
    ...    Test title: PUT Change interface state task - Conflict - Method not implemented
    ...    Test objective: The objective is to test that PUT method is not allowed to update the changed state of the NFV-MANO functional entity application.
    ...    Pre-conditions: 
    ...    Reference: clause 5.5.12.3.3 - ETSI GS NFV-SOL 009 [5] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: 
    Send Put request for Change interface state task
    Check HTTP Response Status Code Is    405
    
PATCH Change interface state task - Conflict - Method not implemented
    [Documentation]    Test ID: 8.3.1.7.5
    ...    Test title: PATCH Change interface state task - Conflict - Method not implemented
    ...    Test objective: The objective is to test that PATCH method is not allowed to update the changed state of the NFV-MANO functional entity application.
    ...    Pre-conditions: 
    ...    Reference: clause 5.5.12.3.4 - ETSI GS NFV-SOL 009 [5] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: 
    Send Patch request for Change interface state task
    Check HTTP Response Status Code Is    405
    
DELETE Change interface state task - Conflict - Method not implemented
    [Documentation]    Test ID: 8.3.1.7.6
    ...    Test title: DELETE Change interface state task - Conflict - Method not implemented
    ...    Test objective: The objective is to test that DELETE method is not allowed to delete the changed state of the NFV-MANO functional entity application.
    ...    Pre-conditions: 
    ...    Reference: clause 5.5.12.3.5 - ETSI GS NFV-SOL 009 [5] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: 
    Send Delete request for Change interface state task
    Check HTTP Response Status Code Is    405