*** Settings ***
Resource          NFVMANOPMKeywords.robot

*** Test Cases ***
POST Individual Performance Report - Method not implemented
    [Documentation]    Test ID: 8.3.2.3.1
    ...    Test title: POST Individual Performance Report - Method not implemented
    ...    Test objective: The objective is to test that POST method is not allowed to create a new NFV-MANO performance report within a monitoring job.
    ...    Pre-conditions: none
    ...    Reference: clause 6.5.5.3.1 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send Post request for Individual Performance Report
    Check HTTP Response Status Code Is    405
    
Get Individual Performance Report
    [Documentation]    Test ID: 8.3.2.3.2
    ...    Test title: Get Individual Performance Report
    ...    Test objective: The objective is to test the retrieval of an individual performance report associated to a monitoring job and perform a JSON schema validation of the collected report data structure
    ...    Pre-conditions: A NFV-MANO instance is instantiated. One or more NFV-MANO performance reports are set for a monitoring job.
    ...    Reference: clause 6.5.5.3.2 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get Individual Performance Report
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is   PerformanceReport

Get Individual Performance Report with invalid resource endpoint
        [Documentation]    Test ID: 8.3.2.3.3
    ...    Test title: Get Individual Performance Report with invalid resource endpoint
    ...    Test objective:  The objective is to test that the retrieval of an individual NFV-MANO performance report associated to a monitoring job fails when using an invalid resource endpoint. 
    ...    Pre-conditions: A NFV-MANO instance is instantiated. One or more NFV-MANO performance reports are set for a monitoring job.
    ...    Reference: clause 6.5.5.3.2 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get Individual Performance Report with invalid resource endpoint
    Check HTTP Response Status Code Is    404

PUT Individual Performance Report - Method not implemented
    [Documentation]    Test ID: 8.3.2.3.4
    ...    Test title: PUT Individual Performance Report - Method not implemented
    ...    Test objective: The objective is to test that PUT method is not allowed to update an existing NFV-MANO performance report within a monitoring job.
    ...    Pre-conditions: none
    ...    Reference: clause 6.5.5.3.3 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send Put request for Individual Performance Report
    Check HTTP Response Status Code Is    405

PATCH Individual Performance Report - Method not implemented
    [Documentation]    Test ID: 8.3.2.3.5
    ...    Test title: PATCH Individual Performance Report - Method not implemented
    ...    Test objective: The objective is to test that PATCH method is not allowed to modify an existing NFV-MANO performance report within a monitoring job.
    ...    Pre-conditions: none
    ...    Reference: clause 6.5.5.3.4 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send Patch request for Individual Performance Report
    Check HTTP Response Status Code Is    405

DELETE Individual Performance Report - Method not implemented
    [Documentation]    Test ID: 8.3.2.3.6
    ...    Test title: DELETE Individual Performance Report - Method not implemented
    ...    Test objective: The objective is to test that DELETE method is not allowed to delete an existing NFV-MANO performance report within a monitoring job
    ...    Pre-conditions: none
    ...    Reference: clause 6.5.5.3.5 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANOM
    ...    Applicability: none
    ...    Post-Conditions: none
    Send Delete request for Individual Performance Report
    Check HTTP Response Status Code Is    405

