*** Settings ***
Resource    environment/variables.txt 
Resource    VNFLCMCoordinationKeywords.robot 
Library    String
Library    REST    ${EM-VNF_SCHEMA}://${EM-VNF_HOST}:${EM-VNF_PORT}    ssl_verify=false
Library    JSONLibrary
Library    JSONSchemaLibrary    schemas/
Library    OperatingSystem
Library    DependencyLibrary

*** Test Cases ***
POST Individual LCM Operation Coordination Results - Method not implemented
    [Documentation]    Test ID: 6.3.6.3.1
    ...    Test title: POST Individual LCM Operation Coordination Results - Method not implemented
    ...    Test Objective: The objective is to test that POST method for individual LCM operation coordination results is not implemented.
    ...    pre-condition: none
    ...    Reference: Clause 10.4.3.3.1 - ETSI GS NFV-SOL 002 [2] v3.5.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none  
    ...    Post-Condition: none
    POST Individual LCM Operation Coordination Results
    Check HTTP Response Status Code Is    405

GET Individual LCM Operation Coordination Results - Coordination is Finished
    [Documentation]    Test ID: 6.3.6.3.2
    ...    Test title: GET Individual LCM Operation Coordination Results
    ...    Test Objective: The objective is to test that coordination is finished and GET method reads individual LCM operation coordination results successfully, and perform a JSON schema validation of the returned LCM coordination data structure.
    ...    pre-condition: LCM operation occurrence resource is in Processing state
    ...    Reference: Clause 10.4.3.3.2 - ETSI GS NFV-SOL 002 [2] v3.5.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: When the Individual LCM Operation Coordination is finished
    ...    Post-Condition: none
    GET Individual LCM Operation Coordination Results
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    LcmCoord

GET Individual LCM Operation Coordination Results - Coordination is Not Finished Yet
    [Documentation]    Test ID: 6.3.6.3.3
    ...    Test title: GET Individual LCM Operation Coordination Results
    ...    Test Objective: The objective is to test that GET method checks that whether Individual LCM Operation Coordination is still ongoing or in the process of being cancelled.
    ...    pre-condition: LCM operation occurrence resource is in Processing state
    ...    Reference: Clause 10.4.3.3.2 - ETSI GS NFV-SOL 002 [2] v3.5.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: When the Individual LCM Operation Coordination is still ongoing or in the process of being cancelled.
    ...    Post-Condition: none
    GET Individual LCM Operation Coordination Results of Ongoing Coordination Action
    Check HTTP Response Status Code Is    202
    Check HTTP Response Body Should be Empty

Get Individual LCM Operation Coordination Results without authentication
    [Documentation]    Test ID: 6.3.6.3.4
    ...    Test title:  Get information about a finished coordination task without authentication
    ...    Test objective: The objective is to try to read an individual coordination task without using authentication
    ...    Pre-conditions: none
    ...    Reference: Clause 10.4.3.3.2 - ETSI GS NFV-SOL 002 [2] v3.5.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none
    ...    Post-Conditions: none
    GET Individual LCM Operation Coordination Results - without authentication
    Check HTTP Response Status Code Is    401

PUT Individual LCM Operation Coordination Results - Method not implemented
    [Documentation]    Test ID: 6.3.6.3.5
    ...    Test title: PUT Individual LCM Operation Coordination Results - Method not implemented
    ...    Test Objective: The objective is to test that PUT method for individual LCM operation coordination results is not implemented.
    ...    pre-condition: none
    ...    Reference: Clause 10.4.3.3.3 - ETSI GS NFV-SOL 002 [2] v3.5.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none  
    ...    Post-Condition: none
    PUT Individual LCM Operation Coordination Results
    Check HTTP Response Status Code Is    405

PATCH Individual LCM Operation Coordination Results - Method not implemented
    [Documentation]    Test ID: 6.3.6.3.6
    ...    Test title: PATCH Individual LCM Operation Coordination Results - Method not implemented
    ...    Test Objective: The objective is to test that PATCH method for individual LCM operation coordination results is not implemented.
    ...    pre-condition: none
    ...    Reference: Clause 10.4.3.3.4 - ETSI GS NFV-SOL 002 [2] v3.5.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none  
    ...    Post-Condition: none
    PATCH Individual LCM Operation Coordination Results
    Check HTTP Response Status Code Is    405

DELETE Individual LCM Operation Coordination Results - Method not implemented
    [Documentation]    Test ID: 6.3.6.3.7
    ...    Test title: PUT Individual LCM Operation Coordination Results - Method not implemented
    ...    Test Objective: The objective is to test that DELETE method for individual LCM operation coordination results is not implemented.
    ...    pre-condition: none
    ...    Reference: Clause 10.4.3.3.5 - ETSI GS NFV-SOL 002 [2] v3.5.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none  
    ...    Post-Condition: none
    DELETE Individual LCM Operation Coordination Results
    Check HTTP Response Status Code Is    405