*** Settings ***
Library           JSONSchemaLibrary    schemas/
Resource          environment/variables.txt
Library           JSONLibrary
Library           OperatingSystem
Library           String
Library           REST    ${VNFM_SCHEMA}://${VNFM_HOST}:${VNFM_PORT}    ssl_verify=false
Suite Setup    Check resource existence and get CallbackUri

*** Test Cases ***
VNF Performance Information Availability Notification
    [Documentation]    Test ID: 6.3.3.10.1
    ...    Test title: VNF Performance Information Availability Notification
    ...    Test objective: The objective is to test that VNF Performance Information Availability Notification is delivered with success to the notification consumer
    ...    Pre-conditions: A VNF performance job is created, and a subscription for information availability notifications is available in the VNFM.
    ...    Reference: Clause 6.4.9.3.1 - ETSI GS NFV-SOL 002 [2] v2.7.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none 
    Post VNF Performance Information Availability Notification
    Check HTTP Response Status Code Is    204
    
VNF Threshold Crossed Notification
    [Documentation]    Test ID: 6.3.3.10.2
    ...    Test title: VNF Threshold Crossed Notification
    ...    Test objective: The objective is to test that VNF Threshold Crossed Notification is delivered with success to the notification consumer
    ...    Pre-conditions: A VNF performance job is created, and a subscription for Threshold Crossed Notification is available in the VNFM.
    ...    Reference: Clause 6.4.9.3.1 - ETSI GS NFV-SOL 002 [2] v2.7.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none 
    Post VNF Threshold Crossed Notification
    Check HTTP Response Status Code Is    204
    
*** Keywords ***
Check resource existence and get CallbackUri
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs/${pmJobId}	
    Integer    response status    200
    Validate Json    response body    PmJob.schema.json
    Set Global Variable    ${callbackResp}    response body callbackUri
    
Check HTTP Response Status Code Is
    [Arguments]    ${expected_status}
    ${status}=    Convert To Integer    ${expected_status}    
    Should Be Equal    ${response['status']}    ${status} 
    Log    Status code validated
    
Post VNF Performance Information Availability Notification
    log    Trying to perform a POST to get notification
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    ${template} =    Get File    jsons/PerformanceInformationAvaliableNotification.json
    ${body}=        Format String   ${template}    objectInstanceId=${objectInstanceId} 
    Post    ${callbackResp}    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}	

Post VNF Threshold Crossed Notification
    log    Trying to perform a POST to get notification
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    ${template} =    Get File    jsons/ThresholdCrossedNotification.json
    ${body}=        Format String   ${template}    thresholdId=${thresholdId}    objectInstanceId=${objectInstanceId} 
    Post    ${callbackResp}    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}	
