*** Settings ***
Resource    VnfSnapshotPackageManagementKeywords.robot 

*** Test Cases ***
POST Individual VNF Snapshot Package - Method not implemented
    [Documentation]    Test ID: 5.3.7.3.1
    ...    Test title: POST Individual VNF Snapshot Package - Method not implemented
    ...    Test objective: The objective is to test that POST method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 11.4.3.3.1 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    POST individual VNF Snapshot Package
    Check HTTP Response Status Code Is    405
    
GET Information about an individual VNF Snapshot Package - SUCCESSFUL
    [Documentation]    Test ID: 5.3.7.3.2
    ...    Test title: GET Information about an individual VNF Snapshot Package - SUCCESSFUL
    ...    Test objective: The objective is to create a new VNF Snapshot Package resource
    ...    Pre-conditions: none
    ...    Reference: Clause 11.4.3.3.2 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET individual VNF Snapshot Package
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    VnfSnapshotPkgInfo
        
GET Information about an individual VNF Snapshot Package - NOT FOUND
     [Documentation]    Test ID: 5.3.7.3.3
    ...    Test title: GET Information about an individual VNF Snapshot Package - NOT FOUND
    ...    Test objective: The objective is to test that the retrieval of individual VNF Snapshot Package fails when using an invalid resource identifier.
    ...    Pre-conditions: At least one individual VNF Snapshot Package is available in the NFV-MANO.
    ...    Reference: Clause 11.4.3.3.2 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET Individual VNF Snapshot Package with Invalid URI
    Check HTTP Response Status Code Is    404
    Check HTTP Response Body Json Schema Is   ProblemDetails

PUT Individual VNF Snapshot Package - Method not implemented 
     [Documentation]    Test ID: 5.3.7.3.4
    ...    Test title: PUT Individual VNF Snapshot Package - Method not implemented
    ...    Test objective: The objective is to test that PUT method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 11.4.3.3.3 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: VNF Snapshot Package not modified
    PUT individual VNF Snapshot Package
    Check HTTP Response Status Code Is    405

PATCH Individual VNF Snapshot Package - Modified
    [Documentation]    Test ID: 5.3.7.3.5
    ...    Test title: PATCH Individual VNF Snapshot Package - Modified
    ...    Test objective: The objective is to test that PATCH method updates the information of a VNF Snapshot package
    ...    Pre-conditions: none
    ...    Reference: Clause 11.4.3.3.4 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    PATCH individual VNF Snapshot Package
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is   VnfSnapshotPkgInfoModifications

PATCH Individual VNF Snapshot Package - Conflict
    [Documentation]    Test ID: 5.3.7.3.6
    ...    Test title: PATCH Individual VNF Snapshot Package - Conflict
    ...    Test objective: The objective is to test that PATCH method does not update the information of a VNF Snapshot package when the state of the VNF snapshot package resource is in a state other than CREATED, ERROR_EXTRACTING or AVAILABLE.
    ...    Pre-conditions: none
    ...    Reference: Clause 11.4.3.3.4 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: The state of the VNF snapshot package resource is in a state other than CREATED, ERROR_EXTRACTING or AVAILABLE.
    ...    Post-Conditions: none
    PATCH individual VNF Snapshot Package - Erroneous State
    Check HTTP Response Status Code Is    409
    Check HTTP Response Body Json Schema Is   ProblemDetails    

DELETE Individual VNF Snapshot Package
    [Documentation]    Test ID: 5.3.7.3.7
    ...    Test title: DELETE Individual VNF Snapshot Package
    ...    Test objective: The objective is to test that DELETE method deletes an individual VNF Snapshot Package resource
    ...    Pre-conditions: none
    ...    Reference: Clause 11.4.3.3.5 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: VNF Snapshot Package deleted
    DELETE individual VNF Snapshot Package
    Check HTTP Response Status Code Is    204
    
DELETE Individual VNF Snapshot Package - Conflict
    [Documentation]    Test ID: 5.3.7.3.8
    ...    Test title: DELETE Individual VNF Snapshot Package - Method Not im
    ...    Test objective: The objective is to test that DELETE method does not delete a VNF Snapshot package when the state of the VNF snapshot package resource is in a state other than CREATED, ERROR or AVAILABLE.
    ...    Pre-conditions: none
    ...    Reference: Clause 11.4.3.3.5 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: The state of the VNF snapshot package resource is in a state other than CREATED, ERROR or AVAILABLE.
    ...    Post-Conditions: VNF Snapshot Package not deleted
    DELETE individual VNF Snapshot Package - Conflict
    Check HTTP Response Status Code Is    409
    Check HTTP Response Body Json Schema Is   ProblemDetails    