*** Settings ***
Resource    environment/variables.txt 
Library    String
Library    REST    ${EM-VNF_SCHEMA}://${EM-VNF_HOST}:${EM-VNF_PORT}    ssl_verify=false
Library    JSONLibrary
Library    JSONSchemaLibrary    schemas/
Library    OperatingSystem
Library    DependencyLibrary

*** Keywords *** 

Check HTTP Response Status Code Is
    [Arguments]    ${expected_status}    
    Should Be Equal As Strings   ${response['status']}    ${expected_status}
    Log    Status code validated 

Check HTTP Response Body Json Schema Is
    [Arguments]    ${input}
    Run Keyword If    '${input}' == 'ProblemDetails'    Should Contain    ${response['headers']['Content-Type']}    application/problem+json
    ...    ELSE    Should Contain    ${response['headers']['Content-Type']}    application/json
    ${schema}=    Catenate    SEPARATOR=    ${input}    .schema.json
    Validate Json    ${schema}    ${response['body']}
    Log    Json Schema Validation OK

Check Postcondition LcmCoord Exists
    Log    Checking that individual lcm coordination exists
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/coordiations/${response['body']['id']}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    LcmCoord

Check HTTP Response Body Should be Empty
    Should Be Empty    ${response['body']}

POST Individual LCM Operation Coordination Results
    Log    Trying to perform a POST. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    POST    ${apiRoot}/lcmcoord/${apiMajorVersion}/coordinations/${coordinationId}
    ${outputResponse}=    Output    response
	Set Suite Variable    ${response}    ${outputResponse} 

GET Individual LCM Operation Coordination Results
    Log    Requesting the retrieve of a finished coordination task 
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/lcmcoord/${apiMajorVersion}/coordinations/${Id_of_Finished_Coordination_Action}
    ${outputResponse}=    Output    response
	Set Suite Variable    ${response}    ${outputResponse} 

GET Individual LCM Operation Coordination Results of Ongoing Coordination Action
    Log    Requesting the retrieve of an ongoing coordination task
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/lcmcoord/${apiMajorVersion}/coordinations/${Id_of_Ongoing_Coordination_Action}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}

GET Individual LCM Operation Coordination Results - without authentication
    Log    Requesting to retrieve a finished coordination task without authentication
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    GET    ${apiRoot}/lcmcoord/${apiMajorVersion}/coordinations/${coordinationId}
    ${outputResponse}=    Output    response
	Set Suite Variable    ${response}    ${outputResponse}

PUT Individual LCM Operation Coordination Results
    Log    Trying to perform a PUT. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    PUT    ${apiRoot}/lcmcoord/${apiMajorVersion}/coordinations/${coordinationId}
    ${outputResponse}=    Output    response
	Set Suite Variable    ${response}    ${outputResponse} 

PATCH Individual LCM Operation Coordination Results
    Log    Trying to perform a PATCH. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    PATCH    ${apiRoot}/lcmcoord/${apiMajorVersion}/coordinations/${coordinationId}
    ${outputResponse}=    Output    response
	Set Suite Variable    ${response}    ${outputResponse} 

DELETE Individual LCM Operation Coordination Results
    Log    Trying to perform a DELETE. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    DELETE    ${apiRoot}/lcmcoord/${apiMajorVersion}/coordinations/${coordinationId}
    ${outputResponse}=    Output    response
	Set Suite Variable    ${response}    ${outputResponse}

POST Cancellation of an Ongoing Individual Coordination Action
    Log    Trying to initiates the cancellation of an ongoing coordination action.
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    POST    ${apiRoot}/lcmcoord/${apiMajorVersion}/coordinations/${Id_of_Ongoing_Coordination_Action}/cancel
    ${outputResponse}=    Output    response
	Set Suite Variable    ${response}    ${outputResponse}

POST Cancellation of an Ongoing Individual Coordination Action - Conflict
    Log    Trying to initiates the cancellation of an ongoing coordination action.
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    POST    ${apiRoot}/lcmcoord/${apiMajorVersion}/coordinations/${Id_of_Finished_Coordination_Action}/cancel
    ${outputResponse}=    Output    response
	Set Suite Variable    ${response}    ${outputResponse}

POST Cancellation of an Ongoing Individual Coordination Action without authorization token
    Log    Requesting the cancellation of an ongoing coordination task without authorization
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Content-Type": "${CONTENT_TYPE_JSON}"}
    POST    ${apiRoot}/${apiName}/${apiMajorVersion}/coordinations/${Id_of_Ongoing_Coordination_Action}/cancel
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

GET Cancellation of an Ongoing Individual Coordination Action
    Log    Trying to perform a GET. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/lcmcoord/${apiMajorVersion}/coordinations/${coordinationId}/cancel
    ${outputResponse}=    Output    response
	Set Suite Variable    ${response}    ${outputResponse}

PUT Cancellation of an Ongoing Individual Coordination Action
    Log    Trying to perform a PUT. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    PUT    ${apiRoot}/lcmcoord/${apiMajorVersion}/coordinations/${coordinationId}/cancel
    ${outputResponse}=    Output    response
	Set Suite Variable    ${response}    ${outputResponse} 

PATCH Cancellation of an Ongoing Individual Coordination Action
    Log    Trying to perform a PATCH. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    PATCH    ${apiRoot}/lcmcoord/${apiMajorVersion}/coordinations/${coordinationId}/cancel
    ${outputResponse}=    Output    response
	Set Suite Variable    ${response}    ${outputResponse} 

DELETE Cancellation of an Ongoing Individual Coordination Action
    Log    Trying to perform a DELETE. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    DELETE    ${apiRoot}/lcmcoord/${apiMajorVersion}/coordinations/${coordinationId}/cancel
    ${outputResponse}=    Output    response
	Set Suite Variable    ${response}    ${outputResponse}      

Check HTTP Response Header Contains
    [Arguments]    ${CONTENT_TYPE_JSON}
    Should Contain    ${response['headers']}    ${CONTENT_TYPE_JSON}
    Log    Header is present

Check HTTP Location Header Contains URI of Resource That Will be Created
    ${indiviCoordActionId}=    Get Value From Json    ${response['headers']}    $..Location
    Should Not Be Empty    ${indiviCoordActionId}

Post coordination of LCM operation Occurance and API Producer has Chosen Synchronous Mode
    Pass Execution If    ${SYNCHRONOUS_MODE_SUPPORT} == 0    The API producer is in Asynchronous Mode. Skipping the test.
    Log    Create coordination action by POST to ${apiRoot}/${apiName}/${apiMajorVersion}/coordinations
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${template} =    Get File    jsons/LcmCoordRequest.json
    ${body}=    Format String    ${template}    vnfInstanceId=${vnfInstanceId}    vnfLcmOpOccId=${vnfLcmOpOccId}    lcmOperationType=${lcmOperationType}    coordinationActionName=${coordinationActionName}    vnfLcmOpOccHref=${vnfLcmOpOccHref}    vnfInstanceHref=${vnfInstanceHref}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/coordinations    ${body}
    ${outputResponse}=    Output    response
	Set Suite Variable    ${response}    ${outputResponse}

Post coordination of LCM operation Occurance and API Producer has Chosen Asynchronous Mode
    Pass Execution If    ${SYNCHRONOUS_MODE_SUPPORT} == 1    The API producer is in Synchronous Mode. Skipping the test.
    Log    Create coordination action by POST to ${apiRoot}/${apiName}/${apiMajorVersion}/coordinations
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${template} =    Get File    jsons/LcmCoordRequest.json
    ${body}=    Format String    ${template}    vnfInstanceId=${vnfInstanceId}    vnfLcmOpOccId=${vnfLcmOpOccId}    lcmOperationType=${lcmOperationType}    coordinationActionName=${coordinationActionName}    vnfLcmOpOccHref=${vnfLcmOpOccHref}    vnfInstanceHref=${vnfInstanceHref}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/coordinations    ${body}
    ${outputResponse}=    Output    response
	Set Suite Variable    ${response}    ${outputResponse}

Post coordination of LCM operation Occurance and API Producer has Chosen Synchronous Mode - Service Unavailable
    Pass Execution If    ${SYNCHRONOUS_MODE_SUPPORT} == 0    The API producer is in Asynchronous Mode. Skipping the test.
    Log    Create coordination action by POST to ${apiRoot}/${apiName}/${apiMajorVersion}/coordinations
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${template} =    Get File    jsons/LcmCoordRequest.json
    ${body}=    Format String    ${template}    vnfInstanceId=${vnfInstanceId}    vnfLcmOpOccId=${vnfLcmOpOccIdServiceUnavailable}    lcmOperationType=${lcmOperationType}    coordinationActionName=${coordinationActionName}    vnfLcmOpOccHref=${vnfLcmOpOccHrefServiceUnavailable}    vnfInstanceHref=${vnfInstanceHref}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/coordinations    ${body}
    ${outputResponse}=    Output    response
	Set Suite Variable    ${response}    ${outputResponse}

Post coordination of LCM operation Occurance - conflict
    Log    Create coordination action by POST to ${apiRoot}/${apiName}/${apiMajorVersion}/coordinations
    Log    Requesting a new coordination task for an LCM Operation occurrence not in PROCESSING state
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${template} =    Get File    jsons/LcmCoordRequest.json
    ${body}=    Format String    ${template}    vnfInstanceId=${vnfInstanceId}    vnfLcmOpOccId=${vnfLcmOpOccIdNotProcessing}    lcmOperationType=${lcmOperationType}    coordinationActionName=${coordinationActionName}    vnfLcmOpOccHref=${vnfLcmOpOccHrefNotProcessing}    vnfInstanceHref=${vnfInstanceHref}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/coordinations    ${body}
    ${outputResponse}=    Output    response
	Set Suite Variable    ${response}    ${outputResponse}

Post Request for coordination of an LCM operation occurrence without authorization token
    Log    Requesting a new coordination task for an LCM Operation occurrence without authorization token
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Content-Type": "${CONTENT_TYPE_JSON}"}
    ${body}=    Get File    jsons/LcmCoordRequest.json
    POST    ${apiRoot}/${apiName}/${apiMajorVersion}/coordinations    ${body}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Post coordination of LCM operation Occurance is Forbidden
    Log    Create coordination action by POST to ${apiRoot}/${apiName}/${apiMajorVersion}/coordinations
    Log    The coordination action request should be rejected	
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${INSUFFICIENT_AUTHORIZATION_TOKEN}"}
    ${template} =    Get File    jsons/LcmCoordRequest.json
    ${body}=    Format String    ${template}    vnfInstanceId=${vnfInstanceId}    vnfLcmOpOccId=${vnfLcmOpOccId}    lcmOperationType=${lcmOperationType}    coordinationActionName=${coordinationActionName}    vnfLcmOpOccHref=${vnfLcmOpOccHref}    vnfInstanceHref=${vnfInstanceHref}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/coordinations    ${body}
    ${outputResponse}=    Output    response
	Set Suite Variable    ${response}    ${outputResponse} 

GET coordination of LCM operation Occurance	
    Log    Trying to perform a GET. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/coordinations
    ${outputResponse}=    Output    response
	Set Suite Variable    ${response}    ${outputResponse} 

PUT coordination of LCM operation Occurance	
    Log    Trying to perform a PUT. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    PUT    ${apiRoot}/${apiName}/${apiMajorVersion}/coordinations
    ${outputResponse}=    Output    response
	Set Suite Variable    ${response}    ${outputResponse} 

PATCH coordination of LCM operation Occurance	
    Log    Trying to perform a PATCH. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    PATCH    ${apiRoot}/${apiName}/${apiMajorVersion}/coordinations
    ${outputResponse}=    Output    response
	Set Suite Variable    ${response}    ${outputResponse} 

DELETE coordination of LCM operation Occurance	
    Log    Trying to perform a DELETE. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    DELETE    ${apiRoot}/${apiName}/${apiMajorVersion}/coordinations
    ${outputResponse}=    Output    response
	Set Suite Variable    ${response}    ${outputResponse} 

POST API Version
    Set Headers    {"Accept":"${ACCEPT_JSON}"} 
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Post    ${apiRoot}/${apiName}/api_versions
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
	
GET API Version
    Set Headers    {"Accept":"${ACCEPT_JSON}"} 
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/api_versions
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
	
PUT API Version
    Set Headers    {"Accept":"${ACCEPT_JSON}"} 
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Put    ${apiRoot}/${apiName}/api_versions
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
	
PATCH API Version
    Set Headers    {"Accept":"${ACCEPT_JSON}"} 
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Patch    ${apiRoot}/${apiName}/api_versions
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
	
DELETE API Version
    Set Headers    {"Accept":"${ACCEPT_JSON}"} 
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Delete    ${apiRoot}/${apiName}/api_versions
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
	
POST API Version with apiMajorVersion
    Set Headers    {"Accept":"${ACCEPT_JSON}"} 
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/api_versions
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
	
GET API Version with apiMajorVersion
    Set Headers    {"Accept":"${ACCEPT_JSON}"} 
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/api_versions
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
	
PUT API Version with apiMajorVersion
    Set Headers    {"Accept":"${ACCEPT_JSON}"} 
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/api_versions
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
	
PATCH API Version with apiMajorVersion
    Set Headers    {"Accept":"${ACCEPT_JSON}"} 
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/api_versions
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
	
DELETE API Version with apiMajorVersion
    Set Headers    {"Accept":"${ACCEPT_JSON}"} 
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Delete    ${apiRoot}/${apiName}/${apiMajorVersion}/api_versions
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 