*** Settings ***
Library           String
Library           JSONSchemaLibrary    schemas/
Resource          environment/variables.txt   
Resource          environment/pmJobs.txt
Library           JSONLibrary
Library           OperatingSystem
Library           REST    ${NFVMANO_SCHEMA}://${NFVMANO_HOST}:${NFVMANO_PORT}    ssl_verify=false
Library           MockServerLibrary

*** Test Cases ***
Create new NFV-MANO Performance Monitoring Job
    [Documentation]    Test ID: 8.3.2.1.1
    ...    Test title:  Create a new NFV-MANO Performance Monitoring Job
    ...    Test objective: The objective is to test the creation of a new NFV-MANO performance monitoring job and perform the JSON schema validation of the returned job data structure
    ...    Pre-conditions: A NFV-MANO instance is instantiated. One or more NFV-MANO performance jobs are set in the NFV-MANO.
    ...    Reference: clause 6.5.3.3.1 - ETSI GS NFV-SOL 009 [7] v3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: The NFV-MANO Performance Job is successfully created on the NFV-MANO
    Send Post Request Create new NFV-MANO Performance Monitoring Job
    Check HTTP Response Status Code Is    201
    Check HTTP Response Body Json Schema Is   PmJob
    Check Postcondition PmJob Exists
    
GET all NFV-MANO Performance Monitoring Jobs
    [Documentation]    Test ID: 8.3.2.1.2
    ...    Test title: GET all NFV-MANO Performance Monitoring Jobs
    ...    Test objective: The objective is to test the retrieval of all the available NFV-MANO performance monitoring jobs and perform a JSON schema validation
    ...    Pre-conditions: A NFV-MANO instance is instantiated. One or more NFV-MANO performance jobs are set in the NFV-MANO.
    ...    Reference: clause 6.5.3.3.2 - ETSI GS NFV-SOL 009 [7] v3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET all NFV-MANO Performance Monitoring Jobs
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is   PmJobs

GET NFV-MANO Performance Monitoring Jobs with attribute-based filter
    [Documentation]    Test ID: 8.3.2.1.3
    ...    Test title: GET all NFV-MANO Performance Monitoring Jobs with attribute-based filter
    ...    Test objective: The objective is to test the retrieval of NFV-MANO performance monitoring jobs using attribute-based filter, perform a JSON schema validation of the collected jobs data structure
    ...    Pre-conditions: A NFV-MANO instance is instantiated. One or more NFV-MANO performance jobs are set in the NFV-MANO.
    ...    Reference: clause 6.5.3.3.2 - ETSI GS NFV-SOL 009 [7] v3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET NFV-MANO Performance Monitoring Jobs with attribute-based filter
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is   PmJobs

GET all NFV-MANO Performance Monitoring Jobs with all_fields attribute selector
    [Documentation]    Test ID: 8.3.2.1.4
    ...    Test title: GET all NFV-MANO Performance Monitoring Jobs with all_fields attribute selector
    ...    Test objective: The objective is to test the retrieval of all NFV-MANO performance monitoring jobs all_fields attribute selector, perform a JSON schema validation of the collected jobs data structure
    ...    Pre-conditions: A NFV-MANO instance is instantiated. One or more NFV-MANO performance jobs are set in the NFV-MANO.
    ...    Reference: clause 6.5.3.3.2 - ETSI GS NFV-SOL 009 [7] v3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET NFV-MANO Performance Monitoring Jobs with all_fields attribute selector
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is   PmJobs

GET all NFV-MANO Performance Monitoring Jobs with exclude_default attribute selector
    [Documentation]    Test ID: 8.3.2.1.5
    ...    Test title: GET all NFV-MANO Performance Monitoring Jobs with exclude_default attribute selector
    ...    Test objective: The objective is to test the retrieval of all NFV-MANO performance monitoring jobs exclude_default attribute selector, perform a JSON schema validation of the collected jobs data structure
    ...    Pre-conditions: A NFV-MANO instance is instantiated. One or more NFV-MANO performance jobs are set in the NFV-MANO.
    ...    Reference: clause 6.5.3.3.2 - ETSI GS NFV-SOL 009 [7] v3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET NFV-MANO Performance Monitoring Jobs with exclude_default attribute selector
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is   PmJobs

GET all NFV-MANO Performance Monitoring Jobs with fields attribute selector
    [Documentation]    Test ID: 8.3.2.1.6
    ...    Test title: GET all NFV-MANO Performance Monitoring Jobs with fields attribute selector
    ...    Test objective: The objective is to test the retrieval of all NFV-MANO performance monitoring jobs fields attribute selector, perform a JSON schema validation of the collected jobs data structure
    ...    Pre-conditions: A NFV-MANO instance is instantiated. One or more NFV-MANO performance jobs are set in the NFV-MANO.
    ...    Reference: clause 6.5.3.3.2 - ETSI GS NFV-SOL 009 [7] v3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: The NFV-MANO supports the use of fields attribute selector
    ...    Post-Conditions: none
    GET NFV-MANO Performance Monitoring Jobs with fields attribute selector
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is   PmJobs

GET all NFV-MANO Performance Monitoring Jobs with exclude_fields attribute selector
    [Documentation]    Test ID: 8.3.2.1.7
    ...    Test title: GET all NFV-MANO Performance Monitoring Jobs with exclude_fields attribute selector
    ...    Test objective: The objective is to test the retrieval of all NFV-MANO performance monitoring jobs exclude_fields attribute selector, perform a JSON schema validation of the collected jobs data structure
    ...    Pre-conditions: A NFV-MANO instance is instantiated. One or more NFV-MANO performance jobs are set in the NFV-MANO.
    ...    Reference: clause 6.5.3.3.2 - ETSI GS NFV-SOL 009 [7] v3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: The NFV-MANO supports the use of exclude_fields attribute selector
    ...    Post-Conditions: none
    GET NFV-MANO Performance Monitoring Jobs with exclude_fields attribute selector
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is   PmJobs

GET NFV-MANO Performance Monitoring Jobs with invalid attribute-based filter
    [Documentation]    Test ID: 8.3.2.1.8
    ...    Test title: GET NFV-MANO Performance Monitoring Jobs with invalid attribute-based filter
    ...    Test objective: The objective is to test that the retrieval of NFV-MANO performance monitoring jobs fails when using invalid attribute-based filter, and perform the JSON schema validation of the failed operation HTTP response
    ...    Pre-conditions: A NFV-MANO instance is instantiated. One or more NFV-MANO performance jobs are set in the NFV-MANO.
    ...    Reference: clause 6.5.3.3.2 - ETSI GS NFV-SOL 009 [7] v3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET NFV-MANO Performance Monitoring Jobs with invalid attribute-based filter
    Check HTTP Response Status Code Is    400
    Check HTTP Response Body Json Schema Is   ProblemDetails

GET NFV-MANO Performance Monitoring Jobs with invalid attribute selector
    [Documentation]    Test ID: 8.3.2.1.9
    ...    Test title: GET NFV-MANO Performance Monitoring Jobs with invalid resource endpoint
    ...    Test objective: The objective is to test that the retrieval of NFV-MANO performance monitoring jobs fails with invalid attribute selector
    ...    Pre-conditions: A NFV-MANO instance is instantiated. One or more NFV-MANO performance jobs are set in the NFV-MANO.
    ...    Reference: clause 6.5.3.3.2 - ETSI GS NFV-SOL 009 [7] v3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET NFV-MANO Performance Monitoring Jobs with invalid attribute selector
    Check HTTP Response Status Code Is    400
    Check HTTP Response Body Json Schema Is   ProblemDetails
    
GET information about multiple Performance Monitoring Jobs to get Paged Response
    [Documentation]    Test ID: 8.3.2.1.10
    ...    Test title: GET information about multiple Performance Monitoring Jobs to get Paged Response
    ...    Test objective: The objective is to retrieve information about the performance monitoring jobs to get paged response
    ...    Pre-conditions: none
    ...    Reference: clause 6.5.3.3.2 - ETSI GS NFV-SOL 009 [7] v3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions:  none
    GET all NFV-MANO Performance Monitoring Jobs
    Check HTTP Response Status Code Is    200
    Check HTTP Response Header Contains Link
    
GET information about multiple Performance Monitoring Jobs for Bad Request Response too big
    [Documentation]    Test ID: 8.3.2.1.11
    ...    Test title: GET information about multiple Performance Monitoring Jobs for Bad Request Response too big
    ...    Test objective: The objective is to test that GET method fail retrieving status information about performance monitoring jobs when Response is too big, and perform the JSON schema validation of the failed operation HTTP response
    ...    Pre-conditions: none
    ...    Reference: clause 6.5.3.3.2 - ETSI GS NFV-SOL 009 [7] v3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET all NFV-MANO Performance Monitoring Jobs
    Check HTTP Response Status Code Is    400
    Check HTTP Response Body Json Schema Is    ProblemDetails
    
GET information about multiple Performance Monitoring Jobs with "fields" and "exclude_default" attribute selector
    [Documentation]    Test ID: 8.3.2.1.12
    ...    Test title: GET all NFV-MANO Performance Monitoring Jobs with "fields" and "exclude_default" attribute selector
    ...    Test objective: The objective is to retrieve all performance monitoring jobs with fields and exclude default attribute selector, and perform the JSON schema validation of the HTTP response.
    ...    Pre-conditions: none
    ...    Reference: clause 5.5.8.3.2 - ETSI GS NFV-SOL 009 [7] v3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET NFV-MANO Performance Monitoring Jobs with fields and exclude_default attribute selector
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    PmJobs

Get information about multiple Performance Monitoring Jobs with malformed authorization token
    [Documentation]    Test ID: 8.3.2.1.13
    ...    Test title: Get information about multiple Performance Monitoring Jobs with malformed authorization token
    ...    Test objective: The objective is to test that the retrieval of information about Performance Monitoring Jobs fails when using malformed authorization token
    ...    Pre-conditions: none
    ...    Reference: clause 6.5.3.3.2 - ETSI GS NFV-SOL 009 [6] v3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: The NFV-MANO entity requires the usage of access tokens for authorizing the API requests.
    ...    Post-Conditions: none
    GET Performance Monitoring Jobs with malformed authorization token
    Check HTTP Response Status Code Is    401

Get information about multiple Performance Monitoring Jobs without authorization token
    [Documentation]    Test ID: 8.3.2.1.14
    ...    Test title: Get information about multiple Performance Monitoring Jobs without authorization token
    ...    Test objective: The objective is to test that the retrieval of information about Performance Monitoring Jobs fails when omitting the authorization token
    ...    Pre-conditions: none
    ...    Reference: clause 6.5.3.3.2 - ETSI GS NFV-SOL 009 [3] v3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: The NFV-MANO entity requires the usage of access tokens for authorizing the API requests.
    ...    Post-Conditions: none
    GET Performance Monitoring Jobs without authorization token
    Check HTTP Response Status Code Is    401

GET information about multiple Performance Monitoring Jobs with expired or revoked authorization token
    [Documentation]    Test ID: 8.3.2.1.15
    ...    Test title: GET information about multiple Performance Monitoring Jobs with expired or revoked authorization token
    ...    Test objective: The objective is to test that the retrieval of information about Performance Monitoring Jobs fails when using expired or revoked authorization token
    ...    Pre-conditions: One or more Network Service Descriptors are onboarded in the NFVO
    ...    Reference: clause 6.5.3.3.2 - ETSI GS NFV-SOL 009 [3] v3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: The NFV-MANO entity requires the usage of access tokens for authorizing the API requests.
    ...    Post-Conditions: none
    GET Performance Monitoring Jobs with expired or revoked authorization token
    Check HTTP Response Status Code Is    401

PUT all NFV-MANO Performance Monitoring Jobs - Method not implemented
    [Documentation]    Test ID: 8.3.2.1.16
    ...    Test title: PUT all NFV-MANO Performance Monitoring Jobs - Method not implemented
    ...    Test objective: The objective is to test that PUT method is not allowed to modify NFV-MANO Performance Monitoring Jobs
    ...    Pre-conditions: none
    ...    Reference: clause 6.5.3.3.3 - ETSI GS NFV-SOL 009 [7] v3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send PUT Request for all NFV-MANO Performance Monitoring Jobs
    Check HTTP Response Status Code Is    405
    
PATCH all NFV-MANO Performance Monitoring Jobs - (Method not implemented)
    [Documentation]    Test ID: 8.3.2.1.17
    ...    Test title: PATCH all NFV-MANO Performance Monitoring Jobs - Method not implemented
    ...    Test objective: The objective is to test that PATCH method is not allowed to update NFV-MANO Performance Monitoring Jobs
    ...    Pre-conditions: none
    ...    Reference: clause 6.5.3.3.4 - ETSI GS NFV-SOL 009 [7] v3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send PATCH Request for all NFV-MANO Performance Monitoring Jobs
    Check HTTP Response Status Code Is    405
    
DELETE all NFV-MANO Performance Monitoring Jobs - Method not implemented
    [Documentation]    Test ID: 8.3.2.1.18
    ...    Test title: DELETE all NFV-MANO Performance Monitoring Jobs - Method not implemented
    ...    Test objective: The objective is to test that DELETE method is not allowed to update NFV-MANO Performance Monitoring Jobs
    ...    Pre-conditions: none
    ...    Reference: clause 6.5.3.3.5 - ETSI GS NFV-SOL 009 [7] v3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send DELETE Request for all NFV-MANO Performance Monitoring Jobs
    Check HTTP Response Status Code Is    405
    
*** Keywords ***
GET all NFV-MANO Performance Monitoring Jobs
    Log    Trying to get all PM Jobs present in the NFV-MANO
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
GET Performance Monitoring Jobs with malformed authorization token
    Pass Execution If    ${AUTH_USAGE} == 0    Skipping test as NFVO is not supporting authentication
    Log    The GET method queries using invalid token
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Authorization": "${BAD_AUTHORIZATION}"}
    Log    Execute Query and validate response
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

GET Performance Monitoring Jobs without authorization token
    Pass Execution If    ${AUTH_USAGE} == 0    Skipping test as it is not supporting authentication
    Log    The GET method queries omitting token
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Log    Execute Query and validate response
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

GET Performance Monitoring Jobs with expired or revoked authorization token
    Pass Execution If    ${AUTH_USAGE} == 0    Skipping test as it is not supporting authentication
    Log    The GET method queries  using invalid token
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Authorization": "${NEG_AUTHORIZATION}"}
    Log    Execute Query and validate response
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
GET NFV-MANO Performance Monitoring Jobs with attribute-based filter
    Log    Trying to get all PM Jobs present in the NFV-MANO, using filter params
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs?${POS_FILTER}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

GET NFV-MANO Performance Monitoring Jobs with all_fields attribute selector
    Log    Trying to get all PM Jobs present in the NFV-MANO, using 'all_fields' filter
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs?all_fields
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

GET NFV-MANO Performance Monitoring Jobs with exclude_default attribute selector
    Log    Trying to get all NFV-MANO Packages present in the NFV-MANO, using filter params
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs?exclude_default
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

GET NFV-MANO Performance Monitoring Jobs with fields attribute selector
    Log    Trying to get all NFV-MANO Packages present in the NFV-MANO, using filter params
    Pass Execution If    ${FIELD_USAGE} == 0    Skipping test as NFV-MANO is not supporting 'fields'
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs?fields=${fields}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
GET NFV-MANO Performance Monitoring Jobs with fields and exclude_default attribute selector
    Log    Trying to get all NFV-MANO Packages present in the NFV-MANO, using filter params
    Pass Execution If    ${FIELD_USAGE} == 0    Skipping test as NFV-MANO is not supporting 'fields'
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs?exclude_default&fields=${fields}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

GET NFV-MANO Performance Monitoring Jobs with exclude_fields attribute selector
    Log    Trying to get all NFV-MANO Packages present in the NFV-MANO, using filter params
    Pass Execution If    ${FIELD_USAGE} == 0    Skipping test as NFV-MANO is not supporting 'fields'
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs?fields=${fields}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

GET NFV-MANO Performance Monitoring Jobs with invalid attribute-based filter
    Log    Trying to get all PM Jobs present in the NFV-MANO, using an erroneous filter param
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs?${NEG_FILTER}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

GET NFV-MANO Performance Monitoring Jobs with invalid attribute selector	
    Log    Query VNF The GET method queries information about multiple VNF instances.
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"} 
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances?fields=wrong_field
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}

Send Post Request Create new NFV-MANO Performance Monitoring Job
    Log    Creating a new PM Job
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    ${template}=    Get File    jsons/CreatePmJobRequest.json
    ${body}=        Format String   ${template}     objectInstanceIds=${objectInstanceIds}

    POST    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs    ${body}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Send PUT Request for all NFV-MANO Performance Monitoring Jobs 
    Log    Trying to perform a PUT. This method should not be implemented
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    PUT    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Send PATCH Request for all NFV-MANO Performance Monitoring Jobs 
    Log    Trying to perform a PUT. This method should not be implemented
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    PATCH    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
Send DELETE Request for all NFV-MANO Performance Monitoring Jobs 
    Log    Trying to perform a PUT. This method should not be implemented
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    PATCH    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Check Postcondition PmJob Exists
    Log    Checking that Pm Job exists
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs/${response['body']['id']}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    PmJob
 
Check HTTP Response Status Code Is
    [Arguments]    ${expected_status}
    ${status}=    Convert To Integer    ${expected_status}    
    Should Be Equal    ${response['status']}    ${status} 
    Log    Status code validated

Check HTTP Response Header Contains
    [Arguments]    ${CONTENT_TYPE}
    Should Contain    ${response['headers']}    ${CONTENT_TYPE}
    Log    Header is present
    
Check HTTP Response Body Json Schema Is
    [Arguments]    ${input}
    Should Contain    ${response['headers']['Content-Type']}    application/json
    ${schema} =    Catenate    SEPARATOR=    ${input}    .schema.json
    Validate Json    ${schema}    ${response['body']}
    Log    Json Schema Validation OK
    
Check HTTP Response Header Contains Link
    ${linkURL}=    Get Value From Json    ${response['headers']}    $..Link
    Should Not Be Empty    ${linkURL}